@echo off
cls
echo EAGLE Demo Installation
echo .
rem --- Dispatcher ----------------------------------------------------------
if "%1"=="?" goto USAGE
if "%1"==""  goto DEFAULT
if "%2"==""  goto CUSTOM_1
if "%3"==""  goto CUSTOM_2
goto USAGE
:USAGE
echo Usage:  %0           for default installation
echo         %0 X:        for default installation to drive X:
echo         %0 X: DIR    for installation into directory DIR on drive X:
goto END
:MISSINGFILES
echo .
echo A file that is necessary for the installation cannot be found.
echo Please make sure you are starting the installation from the drive and
echo directory where '%0' is located!
pause
goto END
rem --- Default Installation ------------------------------------------------
:DEFAULT
%0 C: \EAGLEDMO
goto END
rem --- Installation into \EAGLEDMO on drive %1 -----------------------------
:CUSTOM_1
%0 %1 \EAGLEDMO
goto END
rem --- Installation into %2 on drive %1 ------------------------------------
:CUSTOM_2
echo Installing EAGLE Demo to %1%2
echo .
echo (Press Ctrl-Break to cancel - call "install ?" for installation info)
pause
rem --- Verify source data --------------------------------------------------
if not exist eagle.001 goto MISSINGFILES
if not exist dearj.exe goto MISSINGFILES
rem --- Create target directory ---------------------------------------------
md %1%2
echo check > %1%2\CHECK
if exist %1%2\CHECK goto DIROK1
echo Cannot access directory %1%2
goto END
:DIROK1
del %1%2\CHECK
goto CHECK
rem --- Check for existing files --------------------------------------------
:CHECK
if not exist %1%2\*.* goto COPY
echo .
echo .
echo The destination directory is not empty.
echo If you continue the installation some of these files may be overwritten!
echo .
echo Please make sure you have a backup copy of these files or cancel
echo the installation now and create a backup copy (or install EAGLE
echo into a different directory).
echo .
echo (Press Ctrl-Break to cancel - call "install ?" for installation info)
pause
rem --- Delete obsolete files -----------------------------------------------
if exist %1%2\manual.doc del %1%2\manual.doc >nul
rem --- Copy files ----------------------------------------------------------
:COPY
dearj x eagle.001 -v -jyv %1%2\
if errorlevel 1 goto INSTFAILURE
rem --- Go into target directory --------------------------------------------
%1
cd %2
rem --- Create EAGLE icon ---------------------------------------------------
echo /* --------------- EAGLE Installation ---------------- */  > makeicon.cmd
echo dir     = directory()                                      >> makeicon.cmd
echo parm    = "%%"                                             >> makeicon.cmd
echo exefull = dir"\EAGLE.EXE"                                  >> makeicon.cmd
echo title   = "EAGLE Demo"                                 >> makeicon.cmd
echo call load                                                  >> makeicon.cmd
echo call SysCreateObject "WPProgram", title, "<WP_DESKTOP>", "EXENAME="exefull";PARAMETERS="parm";PROGTYPE=PM;STARTUPDIR="dir";", "update" >> makeicon.cmd
echo /* --- Load the function library, if necessary --- */      >> makeicon.cmd
echo load:                                                      >> makeicon.cmd
echo if \RxFuncQuery("SysLoadFuncs") then return                >> makeicon.cmd
echo call RxFuncAdd "SysLoadFuncs","REXXUTIL","SysLoadFuncs"    >> makeicon.cmd
echo call SysLoadFuncs                                          >> makeicon.cmd
echo return                                                     >> makeicon.cmd
call makeicon.cmd
del makeicon.cmd
rem --- Let user know we are finished ---------------------------------------
echo .
echo End of EAGLE Demo Installation
pause
goto END
rem --- Installation failed -------------------------------------------------
:INSTFAILURE
echo .
echo Error during EAGLE Demo Installation
pause
goto END
:END
