/* Keyboard tester
 *
 * Copyright (c) 2009 John Elliott <jce@seasip.demon.co.uk>
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "kblib.h"




static int st_israw = 1;
static int st_set = 3;
static int st_leds = 0;
static int st_verbose = 0;

void showhelp(void)
{
	fprintf(stderr, "Syntax: KB {options}\n\n"
			"Options:  1 2 3   Scancode set to use\n"
			"          X       Translation on (default off)\n"
			"          V       Verbose\n"
			"          L       Test ability to set LEDs\n");
	exit(0);           
}



int props(void)
{
	char buf[10];
	int cset;
	
	get_id(buf, st_verbose);
	cset = scancode_set(st_verbose);
	printf("ID           = %s\n", buf);
	if (cset >= 0)
	{
		printf("Scancode set = 0x%02x ", cset);
	}
	else
	{
		printf("Scancode set = unknown ");
	}
	switch(cset)
	{
		case 1:		printf("(Set 1, untranslated)"); break;
		case 2:		printf("(Set 2, untranslated)"); break;
		case 3:		printf("(Set 3, untranslated)"); break;
		case 0x43:	printf("(Set 1, translated)"); break;
		case 0x41:	printf("(Set 2, translated)"); break;
		case 0x3f:	printf("(Set 3, translated)"); break;
	}
	putchar('\n');
	return cset;
}	
void check_option(const char *s)
{
	char c;
	
	while (s[0] == '-' || s[0] == '/') ++s;

	c = s[0];
	if (islower(c)) c = toupper(c);

	switch(c)
	{
		case '?':
		case 'H': showhelp(); break;
		case 'X': st_israw = 0; break;
		case 'R': st_israw = 1; break;
		case 'L': st_leds = 1; break;
		case '1': case '2': case '3':
			  st_set = c - '0'; break;
		case 'V': st_verbose = 1; break;
		default:
			printf("Unrecognised option: %s\n\nType KB -H for help.\n", s);
			exit(1);
	}
}



int main(int argc, char **argv)
{
	int n;
	int cset;
	
	for (n = 1; n < argc; n++)
	{
		check_option(argv[n]);
	}
//	wait_kb_pc();
//	wait_pc_kb();

	printf("Keyboard properties on entry:\n");
	cset = props();

	if (st_leds)
	{
		int n, l;

		printf("LED test\n");
		for (n = 0, l = 1; n < 20; n++)
		{
			setleds(l, st_verbose);
			l = l << 1;
			if (l & 8) l = 1;
			showcodes(6);
		}
		return 0;
	}
	
	printf("\nNow switching to scancode set %d, %s mode\n",
		st_set, st_israw ? "raw" : "translated");

	translate(!st_israw);
	set_scancodes(st_set, st_verbose);
	props();
	printf("\nPress keys to see their scancodes. Wait for 10 seconds to finish.\n");
	
	showcodes(180);

	printf("\nRestoring scancode set 2, translated\n");
	set_scancodes(2, st_verbose);
	translate(1);
	showcodes(3);
	return 0;
}
