/* Keyboard tester
 *
 * Copyright (c) 2009 John Elliott <jce@seasip.demon.co.uk>
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */
typedef unsigned char byte;

void wait_pc_kb(void);	/* Wait for the PC->keyboard buffer to become
			 * empty */
void wait_kb_pc(void);	/* Wait for the keyboard->PC input buffer to become
			 * empty */

int wait_ack(void);	/* Wait for the keyboard to return an ACK, NAK
			 * or other single result byte. Returns -1
			 * if timed out, else byte. */
		 
void wait(int n);	/* Wait for <n> ticks of the system clock */

/* Set or reset a bit in the keyboard controller's command register. 
 * Bit 7: Unused
 * Bit 6: Translate set 2 or 3 to set 1 
 * Bit 5: Disable mouse
 * Bit 4: Disable keyboard
 * Bit 3: Disable keylock
 * Bit 2: Cold reboot flag
 * Bit 1: Mouse interrupt enable
 * Bit 0: Keyboard interrupt enable */
void ctl_command(byte mask, int b);

/* Enable or disable translated mode */
void translate(int b);
/* Enable or disable keyboard interrupts */
void kb_interrupt(int b);
/* Show scancodes until <timeout> system ticks have elapsed */
void showcodes(int timeout);
/* Read the current scancode set */
int scancode_set(int verbose);
/* Set the current scancode set */
void set_scancodes(int set, int verbose);
/* Set the LEDs */
void setleds(int l, int verbose);
/* Send a single command byte */
void send_cmd(int c, int verbose);
/* Get the keyboard ID */
void get_id(char *buf, int verbose);

