/* Keyboard tester
 *
 * Copyright (c) 2009 John Elliott <jce@seasip.demon.co.uk>
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

#include <stdio.h>
#include <stdlib.h>
#include "kblib.h"
#include <ctype.h>
#include <string.h>
#include <intrpt.h>
#include <dos.h>

byte sendbuf[128];
int sendlen = 0;

int st_verbose = 0;


void send_buf(void)
{
	int n, m;
	int nres, cur;
	int result[128];
	
	memset(result, 0, sizeof(result));
	kb_interrupt(0);
	di();
	outp(0x64, 0xad);	/* Disable keyboard */
	for (n = 0; n < sendlen; n++)
	{
		printf("Sending  %02x\n", sendbuf[n]);
		wait_pc_kb();
		outp(0x60, sendbuf[n]);
		for (nres = 0; nres < 128; nres++)
		{
			cur = wait_ack();
			if (cur == -1) break;
			result[nres] = cur;
		}
		if (nres)
		{
			printf("Received ");
			for (m = 0; m < nres; m++) 
				printf("%02x ", result[m]);
			printf("\n");
		}
	}
	outp(0x64, 0xae);	/* Enable keyboard */
	ei();
	kb_interrupt(1);
	printf("Any further output: ");
	showcodes(9);
	putchar('\n');
}





int props(void)
{
	char buf[10];
	int cset;
	
	get_id(buf, st_verbose);
	cset = scancode_set(st_verbose);
	printf("ID           = %s\n", buf);
	printf("Scancode set = 0x%02x ", cset);
	switch(cset)
	{
		case 1:		printf("(Set 1, untranslated)"); break;
		case 2:		printf("(Set 2, untranslated)"); break;
		case 3:		printf("(Set 3, untranslated)"); break;
		case 0x43:	printf("(Set 1, translated)"); break;
		case 0x41:	printf("(Set 2, translated)"); break;
		case 0x3f:	printf("(Set 3, translated)"); break;
	}
	putchar('\n');
	return cset;
}	

void help()
{
	fprintf(stderr, "Syntax: KBSEND { -v } hex hex hex ... \n"
			"        -v: Verbose mode\n");
	exit(0);
}


void check_arg(const char *arg)
{
	while (*arg == '-' || *arg == '/') ++arg;

	switch(*arg)
	{
		case 'v': case 'V': st_verbose = 1; break;
		case '?': case 'h': case 'H':
			help();
			break;
		default:
			fprintf(stderr, "Unrecognised option: %s\n", arg);
			exit(1);
	}
	
}


int main(int argc, char **argv)
{
	int n;
	
	for (n = 1; n < argc; n++)
	{
		int x;

		if (sscanf(argv[n], "%x", &x))
		{
			sendbuf[sendlen++] = x;			
		}
		else check_arg(argv[n]);
	}
	if (sendlen == 0)
	{
		printf("Syntax: kbsend hex hex hex ...\n");
		return 1;
	}
	printf("Sending command: ");
	for (n = 0; n < sendlen; n++)
	{
		printf("%02x ", sendbuf[n]);
	}
	putchar('\n');
	wait_pc_kb();
	send_buf();
	return 0;
}
