/************************************************************************

    SHOWKEYS v1.0.0 - Display keyboard input under Windows

    Copyright (C) 2011  John Elliott <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/

// kbinfo.cpp : implementation file
//

#include "stdafx.h"
#include "showkeys.h"
#include "kbinfo.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

// This simple screen just displays the results of calling GetKeyboardType()
// with all possible parameters. It doesn't attempt to parse the results,
// just displays them as numbers.

/////////////////////////////////////////////////////////////////////////////
// CKeyboardInfoDialog dialog


CKeyboardInfoDialog::CKeyboardInfoDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CKeyboardInfoDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CKeyboardInfoDialog)
	m_sInfo0 = "";
	m_sInfo1 = "";
	m_sInfo2 = "";
	//}}AFX_DATA_INIT
}

void CKeyboardInfoDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CKeyboardInfoDialog)
	DDX_Text(pDX, IDC_INFO0, m_sInfo0);
	DDX_Text(pDX, IDC_INFO1, m_sInfo1);
	DDX_Text(pDX, IDC_INFO2, m_sInfo2);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CKeyboardInfoDialog, CDialog)
	//{{AFX_MSG_MAP(CKeyboardInfoDialog)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CKeyboardInfoDialog message handlers

BOOL CKeyboardInfoDialog::OnInitDialog()
{         
	char buf[20];
	
	sprintf(buf, "%d", GetKeyboardType(0)); m_sInfo0 = buf;      
	sprintf(buf, "%d", GetKeyboardType(1)); m_sInfo1 = buf;      
	sprintf(buf, "%d", GetKeyboardType(2)); m_sInfo2 = buf;      
	
	CDialog::OnInitDialog();
	      
	return TRUE;  // return TRUE  unless you set the focus to a control
}
