/************************************************************************

    SHOWKEYS v1.0.0 - Display keyboard input under Windows

    Copyright (C) 2011  John Elliott <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/

// showkeys.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "showkeys.h"

#include "mainfrm.h"
#include "showkdoc.h"
#include "showkvw.h"
#include "kbinfo.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CShowkeysApp

BEGIN_MESSAGE_MAP(CShowkeysApp, CWinApp)
	//{{AFX_MSG_MAP(CShowkeysApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_KEYBOARD_INFORMATION, OnKeyboardInformation)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CShowkeysApp construction

CShowkeysApp::CShowkeysApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CShowkeysApp object

CShowkeysApp NEAR theApp;

/////////////////////////////////////////////////////////////////////////////
// CShowkeysApp initialization

BOOL CShowkeysApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

	// Make this work on Windows 3.0
	AfxEnableWin30Compatibility();
        // Set dialog background color to 3D colour (looks better than grey 
	// on Windows 95 and later)
	SetDialogBkColor(GetSysColor(COLOR_BTNFACE));
	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CShowkeysDoc),
		RUNTIME_CLASS(CMainFrame),     // main SDI frame window
		RUNTIME_CLASS(CShowkeysView));
	AddDocTemplate(pDocTemplate);

	// create a new (empty) document
	OnFileNew();

	if (m_lpCmdLine[0] != '\0')
	{
		// TODO: add command line processing here
	}


	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
// CShowkeysApp commands

void CShowkeysApp::OnKeyboardInformation()
{
	CKeyboardInfoDialog dlg;
	
	dlg.DoModal();
}



/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About
                                 
static LPCTSTR st_szAbout[] =
{
    TEXT("SHOWKEYS v1.0.0 - Display keyboard input under Windows"),
    TEXT(""),
    TEXT("Copyright (C) 2011  John Elliott <jce@seasip.demon.co.uk>"),
    TEXT(""),
    TEXT("This program is free software; you can redistribute it and/or modify"),
    TEXT("it under the terms of the GNU General Public License as published by"),
    TEXT("the Free Software Foundation; either version 2 of the License, or"),
    TEXT("(at your option) any later version."),
    TEXT(""),
    TEXT("This program is distributed in the hope that it will be useful,"),
    TEXT("but WITHOUT ANY WARRANTY; without even the implied warranty of"),
    TEXT("MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the"),
    TEXT("GNU General Public License for more details."),
    TEXT(""),
    TEXT("You should have received a copy of the GNU General Public License"),
    TEXT("along with this program; if not, write to the Free Software"),
    TEXT("Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA."),
	NULL
};                                 
                                 
class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CListBox	m_lbGPL;
	//}}AFX_DATA           
          
// Implementation
	CPen m_peBlack;
	CBrush m_brWhite;
	CBrush m_brGrey;     
	CBrush m_brHalftone;
    CBitmap m_bmHalftone;
    COLORREF m_crWindow, m_crWindowText;

protected:                       
	void SetupColours();
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	afx_msg BOOL OnEraseBkgnd(CDC *pDC);
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);
	afx_msg void OnSysColorChange();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{                   
	m_bmHalftone.LoadBitmap(IDB_HALFTONE);
	m_brHalftone.CreatePatternBrush(&m_bmHalftone);
	SetupColours();
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::SetupColours()
{                       
	m_crWindow = GetSysColor(COLOR_WINDOW);
	m_crWindowText = GetSysColor(COLOR_WINDOWTEXT);
	m_peBlack.CreatePen(PS_SOLID, 1, m_crWindowText);
	m_brWhite.CreateSolidBrush(m_crWindow);
	m_brGrey.CreateSolidBrush(GetSysColor(COLOR_BTNSHADOW));
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Control(pDX, IDC_GPL, m_lbGPL);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	ON_WM_ERASEBKGND()                              
	ON_WM_CTLCOLOR()
	ON_WM_SYSCOLORCHANGE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CShowkeysApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}       

void CAboutDlg::OnSysColorChange()
{
	SetupColours();
	Invalidate();
}

BOOL CAboutDlg::OnEraseBkgnd(CDC *pDC)
{       
	CRect rc, rc2;
	BOOL bResult = CDialog::OnEraseBkgnd(pDC);
	         
	GetDlgItem(IDC_ST_INFOFRAME)->GetWindowRect(&rc);
	ScreenToClient(&rc);                               
	CPen *peOld = pDC->SelectObject(&m_peBlack);
	CBrush *brOld = pDC->SelectObject(&m_brWhite);
	pDC->Rectangle(&rc);
    pDC->SelectObject(&m_brGrey);
    rc2.left = rc.right;
    rc2.right = rc.right + 2;
    rc2.top = rc.top + 1;
    rc2.bottom = rc.bottom + 2;
    pDC->FillRect(&rc2, &m_brGrey);                           
    rc2.left = rc.left + 1;
    rc2.top  = rc.bottom;
    pDC->FillRect(&rc2, &m_brGrey);                           
                        
    GetDlgItem(IDC_ST_FRAME)->GetWindowRect(&rc);
	ScreenToClient(&rc);                               
	COLORREF crbg = pDC->SetBkColor(m_crWindow);
	COLORREF crfg = pDC->SetTextColor(m_crWindowText);
	pDC->SelectObject(&m_brHalftone);
	pDC->Rectangle(&rc);                        
    pDC->SetTextColor(crfg);                       
    pDC->SetBkColor(crbg);             

    GetDlgItem(IDC_ST_TITLE)->GetWindowRect(&rc2);
    ScreenToClient(&rc2);
    rc2.top = rc.top;
    rc2.bottom = rc.bottom;
    pDC->FillRect(&rc2, &m_brWhite);   
                           
	pDC->SelectObject(brOld);
	pDC->SelectObject(peOld);	

	return bResult;
}       

HBRUSH CAboutDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
    switch (pWnd->GetDlgCtrlID())
    {
    	case IDC_ST_TITLE:
    	case IDC_ST_ICON:
    	pDC->SetBkColor(m_crWindow);
    	return (HBRUSH)(m_brWhite.m_hObject);
    }
	return CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
}


BOOL CAboutDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_lbGPL.ResetContent();
	for (int n = 0; st_szAbout[n]; n++)
	{
		m_lbGPL.AddString(st_szAbout[n]);
	} 
	
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}


