/* ginstall.c */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <dos.h>
#include <ctype.h>
#include <conio.h>
#include <dir.h>

#define MAX_SYSTEMS 10
#define MAX_SCRIPT_SIZE 15
#define MAX_FILES 10
#define MAX_DESCRIPTION 10

static char Source_Directory[100];

struct 
{
	char System_Name[81];
	char System_Description[MAX_DESCRIPTION][81];
	int  Number_Of_Desc;
	char Source_Directory[81];
	char Destination_Directory[81];
	int  Number_Of_Files;
	char File[MAX_FILES][13];
	char Script_Name[13];
	int  Number_Of_Scripts;
	char Script[MAX_SCRIPT_SIZE][81];
} Systems[MAX_SYSTEMS];

int Number_Of_Systems = 0;


void Beep()
{
    sound(440);
    delay(100);
    nosound();
    sleep(3);
}

void
Read_Systems()
{
    char buffer[81];
    FILE *Systems_fd;
    int i, j;
    char *token_ptr;

    if ((Systems_fd = fopen("install.scr", "r")) < 0)
    {
	printf("The installation program cannot find the file \"install.scr\"");
	printf("Please make sure that you are in the correct installation\n");
	printf("point, and try again.  For example, if you are installing\n");
	printf("from floppies, make sure you have an \"a:\" prompt.\n");
	exit(1);
	Beep();
	clrscr();
    }

    Number_Of_Systems = 0;
    while (fgets(buffer, 80, Systems_fd))
    {
	if (strncmp(buffer, "//*", 3) == 0)
	{
	    Number_Of_Systems++;
	    if (Number_Of_Systems >= MAX_SYSTEMS)
		break;
	}
	else if (strncmp(buffer, "SYSTEM:", 7) == 0)
	{
	    buffer[strlen(buffer)] = '\0';
	    token_ptr = strtok(buffer, "\t ");
 	    token_ptr = strtok(NULL, "\n"); 
	    strcpy(Systems[Number_Of_Systems].System_Name, token_ptr);
	}
	else if (strncmp(buffer, "SYSTEM_DESC:", 12) == 0)
	{
	    if (Systems[Number_Of_Systems].Number_Of_Desc < MAX_DESCRIPTION)
	    {
	        token_ptr = strtok(buffer, "\t ");
	        token_ptr = strtok(NULL, "\n");
	        strcpy(Systems[Number_Of_Systems].System_Description[Systems[Number_Of_Systems].Number_Of_Desc], token_ptr);
	        Systems[Number_Of_Systems].Number_Of_Desc++;
    	    }
	}
	else if (strncmp(buffer, "SOURCE:", 7) == 0)
	{
	    buffer[strlen(buffer)] = '\0';
	    token_ptr = strtok(buffer, "\t ");
	    token_ptr = strtok(NULL, "\n");
	    strcpy(Systems[Number_Of_Systems].Source_Directory, token_ptr);
	}
	else if (strncmp(buffer, "DESTINATION:", 12) == 0)
	{
	    buffer[strlen(buffer)] = '\0';
	    token_ptr = strtok(buffer, "\t ");
	    token_ptr = strtok(NULL, "\n");
	    strcpy(Systems[Number_Of_Systems].Destination_Directory, token_ptr);
	}
	else if (strncmp(buffer, "SCRIPT_NAME:", 12) == 0)
	{
	    buffer[strlen(buffer)] = '\0';
	    token_ptr = strtok(buffer, "\t ");
	    token_ptr = strtok(NULL, "\n");
	    strcpy(Systems[Number_Of_Systems].Script_Name, token_ptr);
	}
	else if (strncmp(buffer, "FILE:", 5) == 0)
	{
	    if (Systems[Number_Of_Systems].Number_Of_Files < MAX_FILES)
	    {
	        token_ptr = strtok(buffer, "\t ");
	        token_ptr = strtok(NULL, "\n");
	        strcpy(Systems[Number_Of_Systems].File[Systems[Number_Of_Systems].Number_Of_Files], token_ptr);
	        Systems[Number_Of_Systems].Number_Of_Files++;
    	    }
	}
	else if (strncmp(buffer, "SCRIPT:", 7) == 0)
	{
	    if (Systems[Number_Of_Systems].Number_Of_Scripts < MAX_SCRIPT_SIZE)
	    {
	        token_ptr = strtok(buffer, "\t ");
	        token_ptr = strtok(NULL, "\n");
	        strcpy(Systems[Number_Of_Systems].Script[Systems[Number_Of_Systems].Number_Of_Scripts], token_ptr);
	        Systems[Number_Of_Systems].Number_Of_Scripts++;
	    }
	}
    }
}

int
Get_System()
{
    int i, j;
    int Option;

    while(1)
    {
	clrscr();
	printf("\n\n");
        printf(" The following can be installed from this menu\n\n");
        for (i = 0; i < Number_Of_Systems; ++i)
        {
	    printf("   %1.1d - %s\n", i+1, Systems[i].System_Name);
	    for (j = 0; j < Systems[i].Number_Of_Desc; j++)
	    	printf("%s\n", Systems[i].System_Description[j]);
        }
        printf("   Q - Quit\n\n");
        printf("   Enter Option Number: ");

        Option = getche();
        Option = toupper(Option);
        printf("\n");
	if (((Option >= '1') && (Option <= ('0' + Number_Of_Systems))) 
		|| (Option == 'Q'))
		break;
        printf("\n\nYou have not entered a valid command.  Please try again\n\n\n");
	Beep();
	clrscr();
    }
    return(Option);
}

void
Install(Option)
int Option;
{
    int i,j;
    char File_Name[200];
    char Zip_Command[81];
    FILE *Script_fd;

    if (access(Source_Directory, 0) != 0)
    {
	printf("Cannot find the installation directory %s, try again\n",
	    Source_Directory);
    }
    
    if (access(Systems[Option].Destination_Directory, 2) != 0)
    {
        if (mkdir(Systems[Option].Destination_Directory) != 0)
        {
	        printf("Cannot write to %s, try again\n", 
		    Systems[Option].Destination_Directory);
	        Beep();
		return;
         }
    }
    
    sprintf(File_Name, "%s\\unzip.exe", Source_Directory);
    if (access(File_Name, 0) != 0)
    {
	printf("Cannot find unzip.exe in %s, try again\n",
	    Source_Directory);
	Beep();
	return;
    }


    strncpy(File_Name, Systems[Option].Destination_Directory, 2);
    if (File_Name[1] != ':')
    {
	printf("%s is invalid.  You must include the disk drive letter in\n",
		Systems[Option].Destination_Directory);
        printf("your Destination Directory!\n");
	Beep();
	return;
    }
    File_Name[2] = '\0';
    system(File_Name);


    sprintf(File_Name, "cd %s", Systems[Option].Destination_Directory, 2);
    system(File_Name);

    sprintf(Zip_Command, "copy %s\\unzip.exe .", Source_Directory);
    system(Zip_Command);

    for (i = 0; i < Systems[Option].Number_Of_Files; ++i)
    {
        sprintf(File_Name, "%s\\%s", Source_Directory,
	    Systems[Option].File[i]);
        if (access(File_Name, 0) != 0)
        {
	    printf("Cannot find the installation file %s, try again\n",
	        File_Name);
	    Beep();
	    return;
        }
	else
	{
	    sprintf(Zip_Command, "unzip %s\\%s", Source_Directory,
	        Systems[Option].File[i]);
	    system(Zip_Command);
	}
    }

    if (Systems[Option].Number_Of_Scripts >= 1)
    {
        Script_fd = fopen(Systems[Option].Script_Name, "w");
        for (i = 0; i < Systems[Option].Number_Of_Scripts; ++i)
        {
            fprintf(Script_fd, Systems[Option].Script[i], 
		Systems[Option].Destination_Directory);
	    fprintf(Script_fd, "\n");
        }
        fclose(Script_fd);
        printf("The script %s has been created.  Running this script will\n",
	    Systems[Option].Script_Name);
        printf("setup this program for you.\n\n");
	printf("Press any key to continue.\n");
        Beep();
	getch();
    }
}

int
Install_System(Option)
int Option;
{
    char buffer[80];
    int i;

    clrscr();
    printf("\n\nYou can now change the default values for the source and destination directory\n\n");
    printf("The Source directory is currently %s\n\n", 
	Source_Directory); 
    printf("To keep it, just type return, to change it, type the new\n");
    printf("directory name, or type 'quit' to stop this installation.\n");
    printf("If you enter a name, make sure you include the drive (ie d:\\tmp)\n\n");
    printf("Source: ");

    gets(buffer);
    for (i = 0; i < strlen(buffer); ++i)
	buffer[i] = toupper(buffer[i]);
    
    if (strncmp(buffer, "QUIT", 4) == 0)
	return;
    if (strlen(buffer) != 0)
	strcpy(Systems[Option].Source_Directory, buffer);
	
    clrscr();
    printf("\n\nThe Destination directory is currently %s\n\n", 
	Systems[Option].Destination_Directory); 
    printf("To keep it, just type return, to change it, type the new\n");
    printf("directory name, or type 'quit' to stop this installation.\n");
    printf("If you enter a name, make sure you include the drive (ie d:\\tmp)\n\n");
    printf("Destination: ");

    gets(buffer);
    for (i = 0; i < strlen(buffer); ++i)
	buffer[i] = toupper(buffer[i]);
    
    if (strncmp(buffer, "QUIT", 4) == 0)
	return;
    if (strlen(buffer) != 0)
	strcpy(Systems[Option].Destination_Directory, buffer);
	
    Install(Option);
}


int
main(argc, argv)
int argc;
char *argv[];
{
    int Option;
    char *Last_Slash;
    char Temp_Directory[80];

    strcpy(Temp_Directory, argv[0]);
    Last_Slash = strrchr(Temp_Directory,'\\');
    *Last_Slash = '\0';
    sprintf(Source_Directory, "%s", Temp_Directory);

    clrscr();
    printf("\n\n");
    printf("GW-Install (George Washington University Install Program)\n\n");
    printf("This install program was designed for those new to Ada to quickly install\n");
    printf("useful Ada compilers and tools which will get you started with Ada.\n\n");
    printf("Comments can be emailed to ckann@seas.gwu.edu or mfeldman@seas.gwu.edu.\n\n");
    printf("Press any key to continue\n");
    getch();
    clrscr();

    Read_Systems();
    while(1)
    {
        Option = Get_System();
	if (Option == 'Q')
	    break;
	else
	{
	    Option = Option - '1';
	    Install_System(Option);
	}
    }
}
