
------------------------------------------------------------
--        Name: Alden Dima
--      E-mail: dimaaa@seas.gwu.edu
--      School: The George Washington University
--              School of Engineering and Applied Science
--              Washington, D.C.
--       Class: CSci 298 - Independent Study
--     Project: Ada Curses Binding and Textual User Interface
--        File: admendim.adb "adatui-menu_dimension.adb"
--        Date: 12/24/95 
-- Description: One of many adatui subunit bodies, this file
--              implements a subprogram declared in the adatui
--              package.
--   Revisions: 5/31/96 - AAD - Rewrote Ada-Curses binding to
--              enhance portability and maintainability.  Made
--              necessary changes in AdaTUI/TUIDemo to
--              accomodate new binding.  Made minor changes
--              to correct a problem using access types with
--              unconstrained arrays discovered by GNAT 3.03.
--              Eliminated several unused variables.
------------------------------------------------------------

separate (AdaTUI)
procedure menu_dimension (
   a_menu  : a_menu_t;
   lines   : access integer;
   cols    : access integer )
is
   length : integer; 
   max    : integer := 0;
   index  : natural;

begin
--
-- Modified loop to handle changes in menu type - AAD - 5/31/96
--
   index := 0;
   while a_menu.all(index).item_name /= NULL loop
      length := a_menu.all(index).item_name.all'length;
      if length > max then
	 max := length;
      end if;
      index := index + 1;
   end loop;
                        --
   lines.all := index;  -- Now using index to determine menu size - AAD
                        --
   cols.all  := max + 2;
end menu_dimension;
