
------------------------------------------------------------
--        Name: Alden Dima
--      E-mail: dimaaa@seas.gwu.edu
--      School: The George Washington University
--              School of Engineering and Applied Science
--              Washington, D.C.
--       Class: CSci 298 - Independent Study
--     Project: Ada Curses Binding and Textual User Interface
--        File: c.ads
--        Date: 12/25/95
-- Description: Package specification containing Ada
--              definitions of C data types.  Modified c.ads
--              found in cbind documentation to use types 
--              found in Ada 95's interfaces.c package.
------------------------------------------------------------

with interfaces.c; 
with system;

package c is

   max_bound : constant := 2**14;  -- High bound for: char *argv[]

   subtype double is interfaces.c.double;
   subtype float  is interfaces.c.c_float;

   subtype signed_int     is interfaces.c.int;
   subtype signed_short   is interfaces.c.short;
   subtype signed_char    is interfaces.c.signed_char;
   subtype unsigned_int   is interfaces.c.unsigned;
   subtype unsigned_short is interfaces.c.unsigned_short;
   subtype unsigned_char  is interfaces.c.unsigned_char;

   type a_signed_short_t   is access all signed_short;
   type a_signed_int_t     is access all signed_int;
   type a_unsigned_short_t is access all unsigned_short;
   type a_unsigned_int_t   is access all unsigned_int;

   subtype char  is interfaces.c.char;
   subtype charv is interfaces.c.char_array;
   type    charp is access all interfaces.c.char_array;
--
-- Other possible definitions of charp and charv suggested
-- in the cbind documenation:
--
-- type charp is access character;
-- type charv is array(natural) of character;
-- type charp is access charv;
--

   subtype void is integer;
   subtype function_pointer is system.address;

   type bits1 is range 0 .. 2**0;
   for bits1'size use 1;
   type bits2 is range 0 .. 2**1;
   for bits2'size use 2;
   type bits3 is range 0 .. 2**2;
   for bits3'size use 3;
   type bits4 is range 0 .. 2**3;
   for bits4'size use 4;
   type bits5 is range 0 .. 2**4;
   for bits5'size use 5;
   type bits6 is range 0 .. 2**5;
   for bits6'size use 6;
   type bits7 is range 0 .. 2**6;
   for bits7'size use 7;
   type bits8 is range 0 .. 2**7;
   for bits8'size use 8;
   type bits9 is range 0 .. 2**8;
   for bits9'size use 9;
   type bits10 is range 0 .. 2**9;
   for bits10'size use 10;
   type bits11 is range 0 .. 2**10;
   for bits11'size use 11;
   type bits12 is range 0 .. 2**11;
   for bits12'size use 12;
   type bits13 is range 0 .. 2**12;
   for bits13'size use 13;
   type bits14 is range 0 .. 2**13;
   for bits14'size use 14;
   type bits15 is range 0 .. 2**14;
   for bits15'size use 15;
   type bits16 is range 0 .. 2**15;
   for bits16'size use 16;
   type bits17 is range 0 .. 2**16;
   for bits17'size use 17;
   type bits18 is range 0 .. 2**17;
   for bits18'size use 18;
   type bits19 is range 0 .. 2**18;
   for bits19'size use 19;
   type bits20 is range 0 .. 2**19;
   for bits20'size use 20;
   type bits21 is range 0 .. 2**20;
   for bits21'size use 21;
   type bits22 is range 0 .. 2**21;
   for bits22'size use 22;
   type bits23 is range 0 .. 2**22;
   for bits23'size use 23;
   type bits24 is range 0 .. 2**23;
   for bits24'size use 24;
   type bits25 is range 0 .. 2**24;
   for bits25'size use 25;
   type bits26 is range 0 .. 2**25;
   for bits26'size use 26;
   type bits27 is range 0 .. 2**26;
   for bits27'size use 27;
   type bits28 is range 0 .. 2**27;
   for bits28'size use 28;
   type bits29 is range 0 .. 2**28;
   for bits29'size use 29;
   type bits30 is range 0 .. 2**29;
   for bits30'size use 30;

end c;
