-----------------------------------------------------------------------
--
--  File:        gallow.adb
--  Description: HANGMAN gallow display
--  Rev:         0.2
--  Date:        03/01/97
--  Author:      Jerry van Dijk
--  Mail:        jerry@jvdsys.nextjk.stuyts.nl
--
--  Copyright (c) Jerry van Dijk, 1997
--  Forelstraat 211
--  2037 KV  HAARLEM
--  THE NETHERLANDS
--  tel int + 31 23 540 1052
--
--  Permission granted to use for any purpose, provided this copyright
--  remains attached and unmodified.
--
--  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
--  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
--  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
--
-----------------------------------------------------------------------
with Conio;
use  Conio;

package body Gallow is

   procedure Show_Gallow is
   begin
      Textcolor (Magenta);
      Gotoxy (60, 10);
      Cputs("");
      Gotoxy (60, 11);
      Cputs("       ");
      Gotoxy (60, 12);
      Cputs("");
      for I in 13..23 loop
         Gotoxy (60, I);
         Cputs("");
      end loop;
      Gotoxy (59, 24);
      Cputs("");
   end Show_Gallow;

   procedure Display_Body (S : in Gallow_Status) is

      procedure Display_Head is
      begin
         Gotoxy (67, 12);
         Cputs (" ͸");
         Gotoxy (67, 13);
         Cputs ("ڴ   ÿ");
         Gotoxy (67, 14);
         Cputs ("    ");
         Gotoxy (67, 15);
         CPuts ("   ");
         Gotoxy (67, 16);
         Cputs (" ;");
      end Display_Head;

      procedure Display_Body is
      begin
         Gotoxy (67, 16);
         Cputs (" ");
         Gotoxy (67, 17);
         Cputs ("ͻ");
         Gotoxy (67, 18);
         Cputs ("       ");
         Gotoxy (67, 19);
         Cputs ("Ķ");
         Gotoxy (67, 20);
         Cputs ("       ");
         Gotoxy (67, 21);
         Cputs ("ͼ");
      end Display_Body;

      procedure Display_Left_Arm is
      begin
         Gotoxy (64, 18);
         Cputs (" ͹");
         Gotoxy (64, 19);
         Cputs ("ֶ ");
         Gotoxy (64, 20);
         Cputs ("ӽ ");
      end Display_Left_Arm;

      procedure Display_Right_Arm is
      begin
         Gotoxy (75, 18);
         Cputs ("ͻ");
         Gotoxy (77, 19);
         Cputs ("Ƿ");
         Gotoxy (77, 20);
         Cputs ("ӽ");
      end Display_Right_Arm;

      procedure Display_Leg (X : in X_Pos) is
      begin
         Gotoxy (X, 21);
         Cputs ("");
         Gotoxy (X + 1, 22);
         Cputs ("");
         Gotoxy (X, 23);
         Cputs ("׷");
         Gotoxy (X, 24);
         Cputs ("н");
      end Display_Leg;

      procedure Display_Left_Leg is
      begin
         Display_Leg (68);
      end Display_Left_Leg;

      procedure Display_Right_Leg is
      begin
         Display_Leg (72);
      end Display_Right_Leg;

   begin
      Textcolor (Light_Cyan);
      case S is
         when Head        => Display_Head;
         when The_Body    => Display_Body;
         when Upper_Left  => Display_Left_Arm;
         when Upper_Right => Display_Right_Arm;
         when Lower_Left  => Display_Left_Leg;
         when Lower_Right => Display_Right_Leg;
         when others      => null;
      end case;
   end Display_Body;

end Gallow;
