-----------------------------------------------------------------------
--
--  File:        demo.adb
--  Description: Demonstrates the use of the VGA_Grapics package
--  Rev:         0.7
--  Date:        01-feb-98
--  Author:      Jerry van Dijk
--  Mail:        jdijk@acm.org
--
--  Copyright (c) Jerry van Dijk, 1996, 1997, 1998
--  Billie Holidaystraat 28
--  2324 LK Leiden
--  THE NETHERLANDS
--  tel int + 31 71 531 4365
--
--  Permission granted to use for any purpose, provided this copyright
--  remains attached and unmodified.
--
--  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
--  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
--  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
--
-----------------------------------------------------------------------

with Ada.Characters.Latin_1;
with Ada.Text_Io; use Ada.Text_Io;
with Ada.Numerics; use Ada.Numerics;
with Ada.Numerics.Elementary_Functions; use Ada.Numerics.Elementary_Functions;

with PC_Keyboard;  use PC_Keyboard;
with VGA_Graphics; use VGA_Graphics;

procedure Demo is

   Current_Colors : Color_Palette;

   X, Y        : Float;
   Y_Factor    : constant Float := 120.0;
   Step        : constant Float := 2.0 * Pi / 333.0;
   X_Factor    : constant Float := 333.0 / (2.0 * Pi);

   Title       : constant String := "SINEWAVE CONSTRUCTION";
   Explanation : constant String := "GNAT/DOS Vga graphics package " &
                                      "demonstration";
   Prompt      : constant String := "Press <Enter> to return to DOS";

   -- Note this constant is needed since GNAT doesn't seem
   -- to accept -1 in expressions ?!?
   Minus_One      : constant Integer := -1;

   procedure Wait_For_Enter is
   begin
      while Get_Char /= Ada.Characters.Latin_1.CR loop
         null;
      end loop;
   end Wait_For_Enter;

begin

   -- Switch to VGA mode
   VGA_Mode;

   -- Set screen color
   Current_Colors := Read_All_Palette;
   Set_Palette(Current_Colors, Border, Get_Palette(Current_Colors, Blue));
   Clear_Screen(Green);
   Write_All_Palette(Current_Colors);

   -- Draw border
   Vertical_Line(3, 4, Vertical_Maximum-4, Black);
   Vertical_Line(0, 1, Vertical_Maximum-1, White);
   Horizontal_Line(0, Horizontal_Maximum, 0, White);
   Horizontal_Line(3, Horizontal_Maximum-3, 3, Black);
   Vertical_Line(1, 3, Vertical_Maximum-3, Light_Gray);
   Vertical_Line(2, 3, Vertical_Maximum-3, Light_Gray);
   Horizontal_Line(1, Horizontal_Maximum-1, 1, Light_Gray);
   Horizontal_Line(1, Horizontal_Maximum-1, 2, Light_Gray);
   Horizontal_Line(0, Horizontal_Maximum, Vertical_Maximum, Black);
   Vertical_Line(Horizontal_Maximum, 0, Vertical_Maximum-1, Black);
   Vertical_Line(Horizontal_Maximum-3, 4, Vertical_Maximum-4, White);
   Vertical_Line(Horizontal_Maximum-2, 3, Vertical_Maximum-3, Light_Gray);
   Vertical_Line(Horizontal_Maximum-1, 3, Vertical_Maximum-3, Light_Gray);
   Horizontal_Line(1, Horizontal_Maximum-1, Vertical_Maximum-2, Light_Gray);
   Horizontal_Line(1, Horizontal_Maximum-1, Vertical_Maximum-1, Light_Gray);
   Horizontal_Line(3, Horizontal_Maximum-3, Vertical_Maximum-3, White);

   -- Draw Axes
   Vertical_Line(255, 75, 325, White);
   Vertical_Line(256, 75, 325, White);
   Horizontal_Line(10, 590, 200, White);
   Horizontal_Line(10, 590, 201, White);

   -- Draw Circle
   Draw_Circle(135, 200, 120, Magenta);
   Draw_Circle(135, 200, 119, Magenta);

   -- Plot Sinewave
   X := 0.0;
   while X < 2.0 * Pi loop
      Y := Sin(X);
      Put_Pixel(Integer(X * X_Factor) + 257,
                200 + Integer(Y * Y_Factor) * Minus_One, Red);
      X := X + Step;
   end loop;

   -- Draw 45 degrees helplines in circle
   Draw_Line(50, 115, 220, 285, Cyan);
   Draw_Line(50, 285, 220, 115, Cyan);

   -- 45 degrees horizontal helplines
   Horizontal_Line(50, 382, 115, Cyan);
   Horizontal_Line(50, 549, 285, Cyan);

   -- 45 degrees vertical helplines
   Vertical_Line(382, 115, 200, Cyan);
   Vertical_Line(298, 115, 200, Cyan);
   Vertical_Line(465, 285, 201, Cyan);
   Vertical_Line(549, 285, 201, Cyan);

   -- Draw 90 degrees helplines in circle
   Vertical_Line(135, 80, 320, Cyan);
   Horizontal_line(15, 255, 200, Cyan);

   -- 90 degrees horizontal help lines
   Horizontal_Line(135, 340, 80, Cyan);
   Horizontal_Line(135, 507, 320, Cyan);

   -- 90 degrees vertical help lines
   Vertical_Line(340, 80, 200, Cyan);
   Vertical_Line(507, 201, 320, Cyan);

   -- Write Title
   Write_String(((Horizontal_Maximum + 1) -
                (Font_Width * Title'Length)) / 2, 20, Black, Title);

   -- Write explanation
   Fill_Box( 100, 380, 540, 452, Yellow );
   Write_String(((Horizontal_Maximum + 1) -
                (Font_Width * Explanation'Length)) / 2, 396,
                Brown, Explanation);
   Write_String(((Horizontal_Maximum + 1) -
                (Font_Width * Prompt'Length)) / 2, 424, Red, Prompt);

   -- Return to textmode
   Wait_For_Enter;
   TXT_Mode;

exception

   when No_VGA_Error =>
      Put_Line(Standard_Error, "Couldn't switch to VGA mode");

   when No_TXT_Mode_Error =>
      Put_Line(Standard_Error, "Couldn't switch back to text mode");

   when Screen_Buffer_Error =>
      Put_Line(Standard_Error, "Screen_Buffer outside screen or empty");

   when Not_In_VGA_Error =>
      Put_Line(Standard_Error, "Executing graphics command in text mode");

   when Outside_Screen_Error =>
      TXT_Mode;
      Put_Line(Standard_Error, "Trying to access beyond the screen limits");

end Demo;
