SEPARATE (AVL_Trees_Generic)
PROCEDURE Rotate_L (T: IN OUT Tree) IS
------------------------------------------------------------------------
--| Left Rotation in an AVL Tree
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------
  Temp: Tree := T.Left;
BEGIN
  T.Left := Temp.Right;
  Temp.Right := T;
  T.Height := Max(Height(T.Left),Height(T.Right)) + 1;
  Temp.Height := Max(Height(Temp.Left), T.Height) + 1;
  T := Temp;
END Rotate_L;
