GENERIC
 
  TYPE KeyType IS PRIVATE;
  TYPE ElementType IS PRIVATE;
  TYPE IndexType IS (<>);
  TYPE ListType IS ARRAY (IndexType RANGE <>) OF ElementType;
  WITH FUNCTION KeyOf  (Element: ElementType) RETURN KeyType;
  WITH FUNCTION "<"(Left, Right: KeyType) RETURN Boolean;

PROCEDURE Binary_Search_Generic (List    : IN ListType;
                               Target  : IN KeyType;
                               Location: OUT IndexType;
                               Found   : OUT Boolean);
------------------------------------------------------------------
--| Performs an iterative binary search of an ordered array of
--| keys with bounds List'First..List'Last.
--| Pre :   Target and List are defined, and List is sorted upward
--| Post:   If Target is found in array List, returns True in Found
--|         and the location in Location; otherwise, 
--|         returns False in Found and returns in Location 
--|         the location in which to insert Target
--| Raises: Ada will raise Constraint_Error 
--|         if List'Last = IndexType'Last and Target would be
--|         inserted beyond List'Last. 
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: October 1995                                     
------------------------------------------------------------------
