WITH Ada.Text_IO;
PROCEDURE Immediate IS
------------------------------------------------------------------
--| Demonstrate Ada 95 procedure Ada.Text_IO.Get_Immediate, 
--| which allows reading a character without waiting for a <CR> 
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: October 1995                                     
------------------------------------------------------------------

  Command: Character;
  
BEGIN -- Immediate

  Command := 'a';
  LOOP
    EXIT WHEN (Command = 'q') OR (Command = 'Q');
    Ada.Text_IO.Put(Item => 
      "Enter q or Q to quit; any other character to continue.");
    Ada.Text_IO.Get_Immediate(Item => Command);
    Ada.Text_IO.New_Line;
    Ada.Text_IO.Put(Item => "You entered ");
    Ada.Text_IO.Put(Item => Command);
    Ada.Text_IO.New_Line;
  END LOOP;
  
END Immediate;
