WITH Heaps_Generic;
PACKAGE BODY Queues_Generic_Priority IS
------------------------------------------------------------------------
--| Body of Generic Priority Queue Package
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  -- instantiate generic heap package for these conditions
  PACKAGE Heaps IS 
    NEW Heaps_Generic(ElementType => ElementType,
                      KeyType => KeyType,
                      IndexType => Positive,
                      ListType => List);
  
  PROCEDURE MakeEmpty (Q : IN OUT Queue) IS
  BEGIN
    Q.CurrentSize := 0;
  END MakeEmpty;

  PROCEDURE Enqueue (Q : IN OUT Queue; E : IN ElementType) IS
  BEGIN
    IF IsFull(Q) THEN
      RAISE QueueFull;
    ELSE
      -- put new item at end of heap, then filter it up.
      Q.CurrentSize := Q.CurrentSize + 1;
      Q.Store (Q.CurrentSize) := E;
      Heaps.ExtendHeap(Q.Store(1..Q.CurrentSize));
    END IF;
  END Enqueue;

  PROCEDURE Dequeue (Q : IN OUT Queue) IS
  BEGIN
    IF IsEmpty (Q) THEN
      RAISE QueueEmpty;
    ELSE   
      -- overwrite first item with last item, 
      -- then decrease heap size by 1 and filter down
      Q.Store(1) := Q.Store(Q.CurrentSize);
      Q.CurrentSize := Q.CurrentSize - 1;
      Heaps.AlmostHeapToHeap(Q.Store(1..Q.CurrentSize));
    END IF;
  END Dequeue;

  FUNCTION First (Q : IN Queue) RETURN ElementType IS
  BEGIN
    IF IsEmpty(Q) THEN
      RAISE QueueEmpty;
    ELSE
      RETURN Q.Store (1);
    END IF;
  END First;

  FUNCTION IsEmpty (Q : IN Queue) RETURN Boolean IS
  BEGIN
    RETURN Q.CurrentSize = 0;
  END IsEmpty;

  FUNCTION IsFull (Q : IN Queue) RETURN Boolean IS
  BEGIN
    RETURN Q.CurrentSize = Q.Capacity;
  END IsFull;
  
END Queues_Generic_Priority;
