
GENERIC

  TYPE KeyType IS PRIVATE;
  TYPE ElementType IS PRIVATE;
  WITH FUNCTION KeyOf  (Element: ElementType) RETURN KeyType IS <>;
  WITH FUNCTION "<"(Left, Right: KeyType) RETURN Boolean IS <>;

PACKAGE Queues_Generic_Priority IS
------------------------------------------------------------------------
--| Generic package for Priority Queues
--| "<" is used as the means of assigning priority;
--| "<" means lower priority
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  -- type definition

  TYPE Queue (Capacity: Positive) IS LIMITED PRIVATE;

  -- exported exceptions

  QueueFull  : EXCEPTION;
  QueueEmpty : EXCEPTION;

  -- constructors

  PROCEDURE MakeEmpty (Q : IN OUT Queue);
  -- Pre:    Q is defined
  -- Post:   Q is empty

  PROCEDURE Enqueue (Q : IN OUT Queue; E : IN ElementType);
  -- Pre:    Q and E are defined
  -- Post:   Q is returned with E inserted in its proper
  --   position according to Smaller: the largest Element is at
  --   the head of the queue.
  -- Raises: QueueFull if Q already contains Capacity Elements

  PROCEDURE Dequeue (Q : IN OUT Queue);
  -- Pre:    Q is defined
  -- Post:   Q is returned with the first Element discarded
  -- Raises: QueueEmpty if Q contains no Elements

  -- selector

  FUNCTION First (Q : IN Queue) RETURN ElementType;
  -- Pre:    Q is defined
  -- Post:   The first Element of Q is returned
  -- Raises: QueueEmpty if Q contains no Elements

  -- inquiry operations

  FUNCTION IsEmpty (Q : IN Queue) RETURN Boolean;
  -- Pre:    Q is defined
  -- Post:   returns True if Q is empty, False otherwise

  FUNCTION IsFull  (Q : IN Queue) RETURN Boolean;
  -- Pre:    Q is defined
  -- Post:   returns True if Q is full, False otherwise

PRIVATE

  TYPE List IS ARRAY (Positive RANGE <>) OF ElementType;
  TYPE Queue (Capacity: Positive) IS RECORD
    CurrentSize: Natural := 0;
    Store      : List(1..Capacity);
  END RECORD;

END Queues_Generic_Priority;
