WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
WITH Binary_Search_Generic;
PROCEDURE Test_Binary_Search IS
------------------------------------------------------------------------
--| Test of generic binary search, array of records
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: October 1995                                     
------------------------------------------------------------------------

  Success: Boolean;
  WhereFound: Positive;

  SUBTYPE NameType IS String(1..10);
  SUBTYPE ScoreType IS Natural RANGE 0..100;

  TYPE ScoreRecord IS RECORD
    Name: NameType;
    Score: ScoreType := 0;
  END RECORD;      
 
  TYPE ScoreArray IS ARRAY(Positive RANGE <>) OF ScoreRecord;
  Test1: ScoreArray(1..9);

  FUNCTION NameOf   (Item: ScoreRecord) RETURN NameType IS
  BEGIN
    RETURN Item.Name;
  END NameOf;

  PROCEDURE BinarySearch IS
    NEW Binary_Search_Generic(ElementType => ScoreRecord,
                            KeyType => NameType,
                            IndexType => Positive,
                            ListType  => ScoreArray,
                            "<" => "<",
                            KeyOf => NameOf);
 
  PROCEDURE DisplayArray(I: ScoreArray) IS
  BEGIN
    FOR Count IN I'Range LOOP
      Ada.Text_IO.Put(Item => I(Count).Name);
      Ada.Integer_Text_IO.Put(Item => I(Count).Score, Width => 4);
      Ada.Text_IO.New_Line;
    END LOOP;
    Ada.Text_IO.New_Line;
  END DisplayArray;

BEGIN -- Test_Binary_Search
 
  Test1 := (("Bill      ",29),
            ("Dave      ",69),
            ("Ernie     ",50),
            ("Jill      ",75),
            ("Katie     ",66),
            ("Marianne  ",66),
            ("Nora      ",82),
            ("Samuel    ",95),
            ("Yetta     ",95));
  DisplayArray(Test1);

  BinarySearch(Test1, "Dave      ", WhereFound, Success);
  IF Success THEN
    Ada.Text_IO.Put(Item => "Dave is at location ");
    Ada.Integer_Text_IO.Put(Item => WhereFound, Width => 1);
    Ada.Text_IO.New_Line;
  ELSE
    Ada.Text_IO.Put(Item => "Dave would be at location ");
    Ada.Integer_Text_IO.Put(Item => WhereFound, Width => 1);
    Ada.Text_IO.New_Line;
  END IF;
 
  BinarySearch(Test1, "Adam      ", WhereFound, Success);
  IF Success THEN
    Ada.Text_IO.Put(Item => "Adam is at location ");
    Ada.Integer_Text_IO.Put(Item => WhereFound, Width => 1);
    Ada.Text_IO.New_Line;
  ELSE
    Ada.Text_IO.Put(Item => "Adam would be at location ");
    Ada.Integer_Text_IO.Put(Item => WhereFound, Width => 1);
    Ada.Text_IO.New_Line;
  END IF;
 
  BinarySearch(Test1, "Bill      ", WhereFound, Success);
  IF Success THEN
    Ada.Text_IO.Put(Item => "Bill is at location ");
    Ada.Integer_Text_IO.Put(Item => WhereFound, Width => 1);
    Ada.Text_IO.New_Line;
  ELSE
    Ada.Text_IO.Put(Item => "Bill would be at location ");
    Ada.Integer_Text_IO.Put(Item => WhereFound, Width => 1);
    Ada.Text_IO.New_Line;
  END IF;
 
  BinarySearch(Test1, "Mary      ", WhereFound, Success);
  IF Success THEN
    Ada.Text_IO.Put(Item => "Mary is at location ");
    Ada.Integer_Text_IO.Put(Item => WhereFound, Width => 1);
    Ada.Text_IO.New_Line;
  ELSE
    Ada.Text_IO.Put(Item => "Mary would be at location ");
    Ada.Integer_Text_IO.Put(Item => WhereFound, Width => 1);
    Ada.Text_IO.New_Line;
  END IF;
 
  BinarySearch(Test1, "Zachary   ", WhereFound, Success);
  IF Success THEN
    Ada.Text_IO.Put(Item => "Zachary is at location ");
    Ada.Integer_Text_IO.Put(Item => WhereFound, Width => 1);
    Ada.Text_IO.New_Line;
  ELSE
    Ada.Text_IO.Put(Item => "Zachary would be at location ");
    Ada.Integer_Text_IO.Put(Item => WhereFound, Width => 1);
    Ada.Text_IO.New_Line;
  END IF;
 
END Test_Binary_Search;
