WITH Ada.Text_IO;
WITH Employees;
WITH Employees.IO;
WITH Tables;
WITH Debugging_Support;
USE  Debugging_Support;
PROCEDURE Test_Employee_Table IS
------------------------------------------------------------------
--| Simple Test of Employee Table     
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  OneEmployee: Employees.Employee;
  Success: Boolean;
  OneTable: Tables.TableType;

BEGIN -- Test_Employee_Table

  SetDebug(WhichWay => On);

  Tables.InitializeTable(T => OneTable);
  
  FOR Count IN 1..3 LOOP

    Ada.Text_IO.Put(Item => "--------------------");
    Ada.Text_IO.New_Line;

    Employees.IO.Get(Item => OneEmployee);

    Ada.Text_IO.Put(Item => "--------------------");
    Ada.Text_IO.New_Line;

    Tables.Insert(T => OneTable, E => OneEmployee, Success => Success);
    Tables.Traverse(T => OneTable);

    Ada.Text_IO.Put(Item => "--------------------");
    Ada.Text_IO.New_Line;

  END LOOP;

END Test_Employee_Table;
