WITH VStrings; USE VStrings;
FUNCTION Valid_Ident (T : IN VString) RETURN Boolean IS
------------------------------------------------------------------------
--| Simple Lexical Scanner to Determine Validity of an Identifier
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  TYPE State IS (Start, Accepting, Rejecting);
  TYPE InputClass IS (Letter, Digit, Underscore, Illegal);
  TYPE StateTable IS ARRAY (State, InputClass) OF State;
  
  SimpleID : StateTable := 
    ((Accepting, Rejecting, Rejecting, Rejecting),
     (Accepting, Accepting, Accepting, Rejecting),
     (Rejecting, Rejecting, Rejecting, Rejecting));

  S            : VString(MaxLength(T));
  C            : Character;
  Class        : InputClass;
  CurrentState : State;

BEGIN -- Valid_Ident

  S := T;
  CurrentState := Start;

  IF IsEmpty (S) THEN
    RETURN False;
  END IF;

  LOOP
    C := Head (S);

    IF C = 'L' THEN
      Class := Letter;
    ELSIF C = '5' THEN
      Class := Digit;
    ELSIF C = '_' THEN
      Class := Underscore;
    ELSE
      Class := Illegal;
    END IF;

    CurrentState := SimpleID (CurrentState, Class);

    S := Tail (S);
    EXIT WHEN IsEmpty (S);

  END LOOP;

  RETURN (CurrentState = Accepting);
  
END Valid_Ident;
