PACKAGE Vectors IS
------------------------------------------------------------------------
--| Specification for vector arithmetic package
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: October 1995                                     
------------------------------------------------------------------------
 
  TYPE Vector IS ARRAY(Integer RANGE <>) OF Float;
 
  -- exported exception, raised if two vectors are not conformable
  -- (i.e., have different bounds)

  Bounds_Error : EXCEPTION;
 
  FUNCTION "+" (K : Float; Right : Vector) RETURN Vector;
  -- Pre:  K and Right are defined
  -- Post: returns the sum of the vector and the scalar
  --   Result(i) := K + Right(i)
 
  FUNCTION "*" (K : Float; Right : Vector) RETURN Vector;
  -- Pre:  K and Right are defined
  -- Post: returns the product of the vector and the scalar
  --   Result(i) := K * Right(i)
 
  FUNCTION "*" (Left, Right : Vector) RETURN Float;
  -- Pre:    Left and Right are defined
  -- Post:   returns the inner product of Left and Right
  -- Raises: Bounds_Error if Left and Right have different bounds
 
  FUNCTION "+" (Left, Right : Vector) RETURN Vector;
  -- Pre:    Left and Right are defined
  -- Post:   returns the sum of Left and Right
  --    result(i) := Left(i) + Right(i)
  -- Raises: Bounds_Error if Left and Right have different bounds
  
END Vectors;
