WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
WITH Ada.Characters.Handling;
PROCEDURE Concordance IS
------------------------------------------------------------------
--| Finds and displays the number of occurrences of each letter.
--| The case of each letter is immaterial.  Letters with counts
--| of zero are not displayed.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------
   
   Sentinel : CONSTANT Character := '.';

   SUBTYPE UpperCase IS Character RANGE 'A'..'Z';
   SUBTYPE LowerCase IS Character RANGE 'a'..'z';
   TYPE LetterCountArray IS ARRAY (UpperCase) OF Natural;
   TYPE LetterFlags      IS ARRAY (UpperCase) OF Boolean;

   LetterCount : LetterCountArray; -- array of counts   
   LetterFound : LetterFlags;      -- array of flags
   NextChar : Character;                   -- each input character   

BEGIN -- Concordance   

  -- Initialize LetterCount 
  LetterCount := (OTHERS => 0);             -- Initialize counts   
  LetterFound := (OTHERS => False);         -- Initialize flags    

  -- Read and process each data character.   
  Ada.Text_IO.Put(Item => "Enter a line of text ending with a period.");
  Ada.Text_IO.New_Line;

  LOOP
    Ada.Text_IO.Get(Item => NextChar);

    -- Increment the count for this character, if it is a letter
    IF NextChar IN UpperCase THEN
      LetterCount(NextChar) := LetterCount(NextChar) + 1;
      LetterFound(NextChar) := True;
    ELSIF NextChar IN LowerCase THEN
      NextChar := Ada.Characters.Handling.To_Upper(NextChar); 
      LetterCount(NextChar) := LetterCount(NextChar) + 1;
      LetterFound(NextChar) := True;
    END IF;
    EXIT WHEN NextChar = Sentinel;
  END LOOP;

  -- Display counts of letters that are in the line.   
  Ada.Text_IO.New_Line;
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "Letter     Occurrences");
  Ada.Text_IO.New_Line;
  FOR WhichChar IN UpperCase LOOP
    IF LetterFound(WhichChar) THEN
      Ada.Text_IO.Put(Item => "     ");
      Ada.Text_IO.Put(Item => WhichChar);
      Ada.Integer_Text_IO.Put
        (Item => LetterCount(WhichChar), Width => 16);
      Ada.Text_IO.New_Line;
    END IF;
  END LOOP;

END Concordance;
