SEPARATE (Lists_Generic)
PROCEDURE RemoveFront (L: IN OUT List) IS
------------------------------------------------------------------
--| RemoveFront; subunit of Lists_Generic
--| Author: Michael B. Feldman, The George Washington University
--| Last Modified: September 1995
------------------------------------------------------------------

  Temp: ListPtr;

BEGIN -- RemoveFront

  IF L.Head = NULL THEN

    RAISE ListEmpty;
    
  ELSE -- L.Head points to a node; remove it
    
    Temp := L.Head;
    L.Head := L.Head.ALL.Next;   -- jump around first node
    Dispose (X => Temp);
 
  END IF;

END RemoveFront;

