WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
WITH Min_Max;
PROCEDURE Min_Max_Average IS
------------------------------------------------------------------
--| Finds and displays the minimum, maximum, and average
--| of a list of data items.   
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  NumValues:    Positive;  -- input - the number of items to be averaged
  CurrentValue: Integer;   -- the next data item to be added   

  Sum:          Integer;   -- program variable - the sum being accumulated   

  Smallest:     Integer;   -- output - minimum of the data values
  Largest:      Integer;   -- output - maximum of the data values
  Average:      Integer;   -- output - average of the data values

BEGIN  -- Min_Max_Average

  -- Read the number of items to be averaged 
  Ada.Text_IO.Put(Item => 
    "Enter number (at least 1) of integer items to be averaged > ");
  Ada.Integer_Text_IO.Get(Item => NumValues);  
  Ada.Text_IO.New_Line;

  -- Initialize program variables
  Smallest := Integer'Last;
  Largest := Integer'First;
  Sum := 0;

  -- Read each data item, add it to Sum, 
  -- and check if it is a new minimum or maximum
  FOR Count IN 1 .. NumValues LOOP
    Ada.Text_IO.Put(Item => "Integer item no. ");
    Ada.Integer_Text_IO.Put(Item => Count, Width => 1);
    Ada.Text_IO.Put(Item => " > ");
    Ada.Integer_Text_IO.Get(Item => CurrentValue);  

    Sum := Sum + CurrentValue;
    Smallest := Min_Max.Minimum(Value1 => Smallest, Value2 => CurrentValue);
    Largest  := Min_Max.Maximum(Value1 => Largest,  Value2 => CurrentValue);
  END LOOP;

  -- compute the average; since Sum and NumValues are integers,
  -- the average is truncated, that is, the fractional part is discarded

  Average := Sum / NumValues;

  -- Display the results
  Ada.Text_IO.Put(Item => "The Smallest is ");
  Ada.Integer_Text_IO.Put(Item => Smallest, Width => 1);  
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "The Largest is ");
  Ada.Integer_Text_IO.Put(Item => Largest, Width => 1);  
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "The Average is ");
  Ada.Integer_Text_IO.Put(Item => Average, Width => 1);  
  Ada.Text_IO.New_Line;

END Min_Max_Average;
