WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
WITH Min_Max;
PROCEDURE Min_Max_Three IS
------------------------------------------------------------------
--| finds the largest and smallest of three integer values
--| using the Minimum and Maximum functions from package Min_Max
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------
 
  Num1:     Integer;    -- program inputs
  Num2:     Integer;
  Num3:     Integer;
  Largest:  Integer;    -- program outputs
  Smallest: Integer;

BEGIN -- Min_Max_Three

  -- prompt user for inputs
  Ada.Text_IO.Put (Item => "Please enter first integer value  > ");
  Ada.Integer_Text_IO.Get (Item => Num1);
  Ada.Text_IO.Put (Item => "Please enter second integer value > ");
  Ada.Integer_Text_IO.Get (Item => Num2);
  Ada.Text_IO.Put (Item => "Please enter third integer value  > ");
  Ada.Integer_Text_IO.Get (Item => Num3);
  
  -- find largest of the three inputs
  Largest := Min_Max.Maximum(Value1=>Num1, Value2=>Num2);
  Largest := Min_Max.Maximum(Value1=>Largest, Value2=>Num3);
  
  -- find smallest of the three inputs
  Smallest := Min_Max.Minimum(Value1=>Num1, Value2=>Num2);
  Smallest := Min_Max.Minimum(Value1=>Smallest, Value2=>Num3);
   
  -- display results
  Ada.Text_IO.Put (Item => "The smallest number is ");
  Ada.Integer_Text_IO.Put (Item => Smallest, Width => 1);
  Ada.Text_IO.Put (Item => " and the largest number is ");
  Ada.Integer_Text_IO.Put (Item => Largest, Width => 1);
  Ada.Text_IO.New_Line;

END Min_Max_Three; 
