WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
PROCEDURE Multiply_Integers IS
------------------------------------------------------------------
--| Finds the product of a collection of non-zero integers.  If there
--| are multiple consecutive occurrences of the same value, only the
--| the first value is included in the product.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------
  
  Sentinel : CONSTANT Natural := 0;  -- sentinel value   

  NextNum :     Integer;        -- input - new data item   
  PreviousNum : Integer;        -- save previous data item   
  Product :     Integer;        -- output - product of data   

BEGIN -- Multiply_Integers   

  Product := 1;
  PreviousNum := Sentinel;
  Ada.Text_IO.Put (Item => "Enter 0 to stop.");  
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put (Item => "Enter first number > ");
  Ada.Integer_Text_IO.Get (Item => NextNum);          -- priming read

  WHILE NextNum /= Sentinel LOOP
    -- invariant:
    --   No prior value of NextNum is the sentinel and
    --   Product in pass i is Product in pass i-1 if NextNum is
    --   PreviousNum; otherwise, Product in pass i is NextNum * Product
    --   in pass i-1 (for i > 1)

    IF NextNum /= PreviousNum THEN
      Product := Product * NextNum ;        -- compute next product   
    END IF;
    PreviousNum := NextNum;                 -- remember previous item   
    Ada.Text_IO.Put (Item => "Enter next  number  > ");
    Ada.Integer_Text_IO.Get (Item => NextNum);        -- read next item   
  END LOOP;
  -- assert: NextNum is the sentinel and Product is the product of
  --   every value of NextNum such that NextNum /= PreviousNum
    
  Ada.Text_IO.Put (Item => "The product is ");  -- display result   
  Ada.Integer_Text_IO.Put(Item => Product, Width => 1);
  Ada.Text_IO.New_Line;

END Multiply_Integers;
