WITH Ada.Text_IO;
PROCEDURE Palindrome IS
------------------------------------------------------------------
--| Display the reverse of a string of 80 characters or less, and
--| indicate whether the string is a palindrome
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  Input: String(1..80);  -- the input string
  Last : Natural;        -- index of input string's last character
  R    : String(1..80);  -- the reverse of the input string


  -- local function StringReverse

  FUNCTION StringReverse(S: String) RETURN String IS
    -- returns the reverse of a string
    -- Pre: S is defined
    -- Post: returns the reverse of S

  BEGIN -- StringReverse

    -- these are just to illustrate the recursion
    Ada.Text_IO.Put(S);
    Ada.Text_IO.New_Line;

    IF S'Length <= 1 THEN
      RETURN S;
    ELSE
      RETURN StringReverse(S(S'First+1..S'Last)) & S(S'First);
    END IF;

  END StringReverse;

BEGIN -- Palindrome

  FOR Trial IN 1..5 LOOP

    Ada.Text_IO.Put
      (Item => "Please enter a string of 80 characters or less.");
    Ada.Text_IO.New_Line;
    Ada.Text_IO.Get_Line(Item => Input, Last => Last);

    R(1..Last) := StringReverse(Input(1..Last));
    Ada.Text_IO.Put("The reverse of the string is ");
    Ada.Text_IO.New_Line;
    Ada.Text_IO.Put(Item => R(1..Last));
    Ada.Text_IO.New_Line;

    IF R (1..Last) = Input (1..Last) THEN
      Ada.Text_IO.Put(Item => "The string is a palindrome.");
      Ada.Text_IO.New_Line;
    ELSE
      Ada.Text_IO.Put(Item => "The string is not a palindrome.");
      Ada.Text_IO.New_Line;
    END IF;

    Ada.Text_IO.New_Line;

  END LOOP;

END Palindrome;
