WITH Ada.Text_IO; USE Ada.Text_IO;
WITH Currency; USE Currency;
WITH Dates; USE Dates;
WITH Persons; USE Persons;
WITH Personnel; USE Personnel;
WITH Payroll; USE Payroll;
PROCEDURE Payroll_Array IS
------------------------------------------------------------------
--| Demonstrates the use of classwide general access types
--| and dispatching operations
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
------------------------------------------------------------------
  
  George  : ALIASED Person;
  Mary    : ALIASED Employee;
  Martha  : ALIASED Professional;
  Virginia: ALIASED Sales;
  Herman  : ALIASED Clerical;
  -- These values can now be designated by general access values
  
  TYPE PayrollPointer IS ACCESS ALL Person'Class;
  -- a PayrollPointer value can designate a value of type
  -- Person, or of any type derived from Person, such as
  -- Employee, Sales, Professional, or Clerical
  
  TYPE PayrollArray IS ARRAY (1..5) OF PayrollPointer;
  -- We can put all our employees in an array by designating
  -- them with PayrollPointer values
  
  Company: PayrollArray;

BEGIN

  -- first construct all the people, as before
  
  George := Persons.Constructors.MakePerson(
             Name      => "George",
             Gender    => Male,
             BirthDate => Date_Of(1971,Nov,2));

  Mary := Personnel.Constructors.MakeEmployee(
             Name      => "Mary",  
             Gender    => Female,
             BirthDate => Date_Of(1950,Oct,21),
             ID        => 1234,
             StartDate => Date_Of(1989,Jul,1));
 
  Martha := Payroll.Constructors.MakeProfessional(
             Name        => "Martha",
             Gender      => Female,
             BirthDate   => Date_Of(1947,Jul,8),
             ID          => 2222,
             StartDate   => Date_Of(1985,Jun,6),
             MonthSalary => MakeCurrency(50000.00));

  Virginia := Payroll.Constructors.MakeSales(
             Name       => "Virginia",
             Gender     => Female,
             BirthDate  => Date_Of(1955,Feb,1),
             ID         => 3456,
             StartDate  => Date_Of(1990,Jan,1),
             WeekSalary => MakeCurrency(2500.00),
             CommRate   => 0.25); 
 
  Herman := Payroll.Constructors.MakeClerical(
             Name       => "Herman",
             Gender     => Male,
             BirthDate  => Date_Of(1975,May,13),
             ID         => 1557,
             StartDate  => Date_Of(1991,Jul,1),
             HourlyWage => MakeCurrency(7.50));

  -- Now put the people into the company; each array element is
  -- a different type!
  
  Company := (Herman'Access, Martha'Access, Virginia'Access,
              Mary'Access, George'Access);
              
  -- Now display them all. Note that each time Put is invoked,
  -- precisely the appropriate Put is "dispatched".

  FOR Which IN Company'Range LOOP
    Put(Company(Which).ALL);
    Ada.Text_IO.Put_Line(Item => "------------------------");
  END LOOP;  
 
END Payroll_Array; 
