WITH Ada.Calendar;
WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
PACKAGE BODY Simple_Dates IS
------------------------------------------------------------------
--| Body for package to represent calendar dates
--| in a form convenient for reading and displaying.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  PACKAGE Month_IO IS 
    NEW Ada.Text_IO.Enumeration_IO(Enum => Months);


  PROCEDURE Get(Item: OUT Date) IS

  BEGIN -- Get

    Month_IO.Get(Item => Item.Month);
    Ada.Integer_Text_IO.Get(Item => Item.Day);
    Ada.Integer_Text_IO.Get(Item => Item.Year);

  END Get;


  PROCEDURE Put(Item: IN Date) IS

  BEGIN -- Put

    Month_IO.Put (Item => Item.Month, Width=>1);
    Ada.Text_IO.Put(Item => ' ');
    Ada.Integer_Text_IO.Put(Item => Item.Day, Width => 1);
    Ada.Text_IO.Put(Item => ' '); 
    Ada.Integer_Text_IO.Put(Item => Item.Year, Width => 4);

  END Put;

  FUNCTION Today RETURN Date IS
 
    Right_Now  : Ada.Calendar.Time;     -- holds internal clock value
    Result       : Date; 
   
  BEGIN -- Today
 
    -- Get the current time value from the computer's clock
    Right_Now := Ada.Calendar.Clock;
 
    -- Extract the current month, day, and year from the time value 
    Result.Month := Months'Val(Ada.Calendar.Month(Right_Now)- 1); 
    Result.Day := Ada.Calendar.Day  (Right_Now);
    Result.Year := Ada.Calendar.Year (Date => Right_Now);
 
    RETURN Result;

  END Today;

END Simple_Dates;
