WITH Ada.Calendar;
PACKAGE Simple_Dates IS
------------------------------------------------------------------
--| Specification for package to represent calendar dates
--| in a form convenient for reading and displaying.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  TYPE Months IS
    (Jan, Feb, Mar, Apr, May, Jun, Jul, Aug, Sep, Oct, Nov, Dec);

  TYPE Date IS RECORD
    Month: Months;
    Day:   Ada.Calendar.Day_Number;
    Year:  Ada.Calendar.Year_Number;
  END RECORD;

  PROCEDURE Get(Item: OUT Date);
  -- Pre:  None
  -- Post: Reads a date in mmm dd yyyy form, returning it in Item

  PROCEDURE Put(Item: IN Date);
  -- Pre:  Item is defined
  -- Post: Displays a date in mmm dd yyyy form

  FUNCTION Today RETURN Date;
  -- Pre:  None
  -- Post: Returns today's date

END Simple_Dates;
