WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
PROCEDURE Test_Binary_Search IS
------------------------------------------------------------------
--| Test program for Recursive Binary Search
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  TYPE SearchArray IS ARRAY(Positive RANGE <>) OF Integer;
  Test: SearchArray(1..9);

  FUNCTION BinarySearch (Slice: SearchArray; Target: Integer) RETURN Natural IS
  -- Performs a recursive binary search of an ordered array of 
  -- keys with bounds Slice'First..Slice'Last.
  -- Pre : Target and Slice are defined.
  --     0 < Slice'First <= Slice'Last
  -- Post: Returns the subscript of Target if found in array Slice;
  --     otherwise, returns 0
  
    Middle : Natural;      -- the subscript of the middle element   

  BEGIN -- BinarySearch   

    Middle := (Slice'First + Slice'Last) / 2; -- define Middle   

    -- Determine if Target is found or missing or redefine subarray.   

    IF Slice'Length = 0 THEN
      RETURN 0;                           -- stopping case: Target missing   
    ELSIF Slice(Middle) = Target THEN
      RETURN Middle;                      -- stopping case: Target found   
    ELSIF Slice(Middle) > Target THEN     -- search lower subarray   
      RETURN BinarySearch (Slice(Slice'First..Middle-1),Target);   
    ELSE                                  -- search upper subarray   
      RETURN BinarySearch (Slice(Middle+1..Slice'Last),Target);  
    END IF;

  END BinarySearch;

BEGIN -- Test_Binary_Search

  Test := (20,35,37,40,45,50,51,55,67);

  Ada.Text_IO.Put(Item => "BinarySearch(Test,35) is");
  Ada.Integer_Text_IO.Put(Item => BinarySearch(Test,35));
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "BinarySearch(Test,19) is");
  Ada.Integer_Text_IO.Put(Item => BinarySearch(Test,19));
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "BinarySearch(Test,75) is");
  Ada.Integer_Text_IO.Put(Item => BinarySearch(Test,75));
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "BinarySearch(Test,20) is");
  Ada.Integer_Text_IO.Put(Item => BinarySearch(Test,20));
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "BinarySearch(Test,67) is");
  Ada.Integer_Text_IO.Put(Item => BinarySearch(Test,67));
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "BinarySearch(Test,54) is");
  Ada.Integer_Text_IO.Put(Item => BinarySearch(Test,54));
  Ada.Text_IO.New_Line;

END Test_Binary_Search;
