WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
PROCEDURE Test_Print_Backward IS
------------------------------------------------------------------
--| Demonstration of recursive procedure to print an array backward
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  TYPE IntArray IS ARRAY(Integer RANGE <>) OF Integer;
  Test: IntArray(1..10);

  PROCEDURE PrintBackward (X : IntArray) IS
    
    -- Prints a slice of an integer array X with bounds X'First..X'Last.
    -- Pre : Array X is defined and X'First <= X'Last. 
    -- Post: Displays X(X'Last), X(X'Last-1), ... , X(X'First)
    
  BEGIN -- PrintBackward 

    IF X'First = X'Last THEN -- stopping case - slice has only one element
      Ada.Integer_Text_IO.Put(Item => X(X'Last), Width => 3); 
    ELSIF X'First > X'Last THEN    -- error in specifying slice bounds
      Ada.Text_IO.Put(Item => "Error in bounds of array slice");  
      Ada.Text_IO.New_Line;
    ELSE
      -- recursive step   
      Ada.Integer_Text_IO.Put(Item => X(X'Last), Width => 3);
      PrintBackward (X => X(X'First..X'Last-1));
    END IF;

  END PrintBackward;

BEGIN -- Test_Print_Backward

  Test := (1,3,5,7,9,11,13,15,17,19);
  PrintBackward(X => Test(1..3));
  Ada.Text_IO.New_Line;

END Test_Print_Backward;
