WITH Ada.Text_IO;
WITH Simple_Dates;
PROCEDURE Test_Simple_Dates IS
------------------------------------------------------------------
--| Program to test the Simple_Dates package
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  D: Simple_Dates.Date;

BEGIN -- Test_Simple_Dates

  -- first test the function Today
  D := Simple_Dates.Today;
  Ada.Text_IO.Put(Item => "Today is ");
  Simple_Dates.Put(Item => D);
  Ada.Text_IO.New_Line;

  LOOP

    BEGIN -- block for exception handler
      Ada.Text_IO.Put("Please enter a date in MMM DD YYYY form > ");
      Simple_Dates.Get(Item => D);
      EXIT; -- only if no exception is raised
    EXCEPTION
      WHEN Constraint_Error =>
        Ada.Text_IO.Skip_Line;
        Ada.Text_IO.Put(Item => "Badly formed date; try again, please.");
        Ada.Text_IO.New_Line;
      WHEN Ada.Text_IO.Data_Error =>
        Ada.Text_IO.Skip_Line;
        Ada.Text_IO.Put(Item => "Badly formed date; try again, please.");
        Ada.Text_IO.New_Line;
    END;

  END LOOP;
  -- assert: at this point, D contains a correct date record

  Ada.Text_IO.Put(Item => "You entered ");
  Simple_Dates.Put(Item => D);
  Ada.Text_IO.New_Line;

END Test_Simple_Dates;
