WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
WITH Ada.Calendar;
PROCEDURE Time_of_Day IS
------------------------------------------------------------------
--| Displays the current time in hh:mm:ss form, 24-hour clock
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  TYPE DayInteger IS RANGE 0..86400;
  
  CurrentTime      : Ada.Calendar.Time;
  SecsPastMidnight : DayInteger;  -- could be larger than 32767
  MinsPastMidnight : Natural;
  Secs             : Natural;
  Mins             : Natural;
  Hrs              : Natural;

BEGIN -- Time_of_Day

  CurrentTime := Ada.Calendar.Clock;

  SecsPastMidnight := DayInteger(Ada.Calendar.Seconds(CurrentTime));
  MinsPastMidnight := Natural(SecsPastMidnight/60);
  Secs             := Natural(SecsPastMidnight REM 60);
  Mins             := MinsPastMidnight REM 60;
  Hrs              := MinsPastMidnight / 60;

  Ada.Text_IO.Put(Item => "The current time is ");
  Ada.Integer_Text_IO.Put (Item => Hrs, Width => 1);
  Ada.Text_IO.Put (Item => ':');

  IF Mins < 10 THEN
    Ada.Text_IO.Put (Item => '0');
  END IF;
  Ada.Integer_Text_IO.Put (Item => Mins, Width => 1);
  Ada.Text_IO.Put (Item => ':');

  IF Secs < 10 THEN
    Ada.Text_IO.Put (Item => '0');
  END IF;
  Ada.Integer_Text_IO.Put (Item => Secs, Width => 1);

END Time_of_Day;
