WITH Ada.Text_IO;
WITH My_Int_IO;
WITH Ada.Calendar; 
PROCEDURE Todays_Date_2 IS
------------------------------------------------------------------
--|                                            
--| Finds today's date and displays it in the form MONTH dd, yyyy
--| An enumeration type is used for months
--| The date is gotten from PACKAGE Ada.Calendar
--|                                                              
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
--|                                                             
------------------------------------------------------------------
 
  TYPE Months IS 
     (January, February, March, April, May, June, 
      July, August, September, October, November, December);

  PACKAGE Months_IO IS NEW Ada.Text_IO.Enumeration_IO(Enum => Months);
 
  Right_Now  : Ada.Calendar.Time;           -- holds internal clock value
  This_Year  : Ada.Calendar.Year_Number;    -- holds current year
  This_Month : Ada.Calendar.Month_Number;   -- holds current month 
  This_Day   : Ada.Calendar.Day_Number;     -- holds current day

  Month_Name: Months;
   
BEGIN -- Todays_Date_2
 
  -- Get the current time value from the computer's clock
  Right_Now := Ada.Calendar.Clock;
 
  -- Extract the current month, day, and year from the time value 
  This_Month := Ada.Calendar.Month(Date => Right_Now);
  This_Day   := Ada.Calendar.Day  (Date => Right_Now);
  This_Year  := Ada.Calendar.Year (Date => Right_Now);
 
  -- Format and display the date
  Month_Name := Months'Val(This_Month - 1); 
 
  Ada.Text_IO.Put (Item => "Today's date is ");
  Months_IO.Put (Item => Month_Name, Set => Ada.Text_IO.Upper_Case);
  Ada.Text_IO.Put (Item => ' ');
  My_Int_IO.Put (Item => This_Day, Width => 1);
  Ada.Text_IO.Put (Item => ',');
  My_Int_IO.Put (Item => This_Year, Width => 5);         
  Ada.Text_IO.New_Line;
 
END Todays_Date_2;
