WITH Ada.Text_IO;
WITH Ada.Float_Text_IO;
PROCEDURE Worm_and_Apple IS
------------------------------------------------------------------
--| Displays distances between a worm and an apple.  The worm keeps reducing
--| the distance by its body length until it is close enough to bite the apple.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  SUBTYPE NonNegFloat IS Float RANGE 0.0 .. Float'Last;
  
  WormLength: CONSTANT NonNegFloat := 3.5;  -- worm body length in inches
 
  InitialDist: NonNegFloat;  -- input - starting distance of worm from apple  
  Distance:    NonNegFloat;  -- output - distance between worm and apple   
 
BEGIN -- Worm_and_Apple   

  Ada.Text_IO.Put(Item => "Initial distance (float) between worm and apple > ");
  Ada.Float_Text_IO.Get(Item => InitialDist);  
  Ada.Text_IO.New_Line; 
 
  -- Cut the distance between the worm and the apple by the worm's
  -- body length until the worm is close enough to bite the apple 
  Distance := InitialDist;

  WHILE Distance > WormLength LOOP
    Ada.Text_IO.Put(Item => "The distance is ");
    Ada.Float_Text_IO.Put(Item => Distance, Fore => 4, Aft => 2, Exp => 0);
    Ada.Text_IO.New_Line;

    Distance := Distance - WormLength;   -- reduce Distance 
  END LOOP;
 
  -- Display final distance before entering the apple.   
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "Final distance between worm and apple is ");
  Ada.Float_Text_IO.Put(Item => Distance, Fore => 4, Aft => 2, Exp => 0);
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "The worm bites the apple.");
  Ada.Text_IO.New_Line;

END Worm_and_Apple;
