
   --------------------------------------------------------------------
--|  Package  : Spider                                                 |
   --------------------------------------------------------------------
--|  Abstract :                                                        |
--|     This package provides procedures to emulate "Spider"           |
--|     primitives.  The spider is a robot who can move around         |
--|     the screen drawing simple patterns.                            |
--|                                                                    |
   --------------------------------------------------------------------
--|  File            : spider.ads              Version : 1.0           |
--|  Compiler/System : Alsys ADa                                       |
--|  Author          : John Dalbey             Date :  9/18/92         |
   --------------------------------------------------------------------

PACKAGE Spider IS

TYPE Switch       IS (on,off);                   -- boolean type
TYPE ScreenColors IS (red, blue, green, black);  -- available colors

  PROCEDURE Reset;
  -- Draw the Spider's room on the screen and put the spider in the center.

  PROCEDURE Start;
  -- Draw a random size room on the screen and put the spider in the
  -- upper left corner.

  -- Change the color of ink with which the spider draws
  PROCEDURE Blue;
  PROCEDURE Green;
  PROCEDURE Red;
  PROCEDURE Black;

  PROCEDURE Step;
  -- Take one step forward in the direction the spider is facing.
  -- EXCEPTIONS: Hit_the_Wall is raised if you try to step into a wall.

  PROCEDURE Turn;
  -- Turn 90 degrees to the right.

  FUNCTION  AtWall return boolean;
  -- Return TRUE if the spider is standing next to a wall (edge of the room)
  -- and facing it.

  PROCEDURE Quit;
  -- End the drawing

  PROCEDURE Debug (Setting: Switch);
  -- Turn on or off single stepping through the program.

  FUNCTION  Debug RETURN Boolean;
  -- Return current debug setting.

END Spider;
