/*
   HELP ENGINE PARA GWADA

   Mdulo ADAVIO.H
   Declaracoes especificas para o mdulo de vdeo

   Trabalho de conclusao
   Bacharelado de Informatica

   Ulrich Peters
   Rafael Presoto
   Jerry Dressler
*/

typedef union vel VEL; /* usado apenas como abreviacao */
struct velb {          /* uma posicao da memoria de video como 2 bytes */
	     char caractere,    /* codigo ASCII */
		  atributo;     /* atributo */
	    };

struct velw {          /* uma posicao da memoria de video como 1 word */
	     int conteudo;     /* codigo ASCII e atributo */
	    };

union vel {            /* descreve uma posicao da tela */
	   struct velb h;
	   struct velw x;
	  };

#define NOCLEAR 0xff

/* cdigos dos diferentes sistemas de vdeo */
#define MDA       0
#define CGA       1
#define EGA       2
#define EGA_MONO  3
#define VGA       4
#define VGA_MONO  5
#define MCGA      6
#define MCGA_MONO 7

/* macros */
#define COL(v, h) ((char) (((h) << 4) | (v)) )
#define BUFLEN(x1, y1, x2, y2) \
	  ( ((x2)-(x1)+1) * ((y2)-(y1)+1) * sizeof( VEL ) )
#define AKTZ ( vlinha )
#define AKTS ( vcoluna )
#define VL(i) (( i ) + viewx1)
#define VO(i) (( i ) + viewy1)
#define VR(i) (( i ) + viewx2)
#define VU(i) (( i ) + viewy2)
#define VCOL (viewx2 - viewx1 + 1)
#define VROW (viewy2 - viewy1 + 1)
#define MOVE(s, d, l) movedata( FP_SEG( (void far *) s ), \
				FP_OFF( (void far *) s ), \
				FP_SEG( (void far *) d ), \
				FP_OFF( (void far *) d ), \
				l )

/* prototypes */
void VioInit(void);
void VioGet(int x1, int y1, int x2, int y2, VEL far * bptr);
void VioPut(int x1, int y1, int x2, int y2, VEL far * bptr);
int VioWinOpen(int x1, int y1, int x2, int y2);
void VioWinClose(int redraw);
void VioSetCursor(int coluna, int linha);
void VioPrint(int coluna, int linha, char cor, char cursor, char * string);
void VioPrintf(int coluna, int linha, char cor, char cursor, char * string, ... );
char *VioStrep(char caractere, int num);
void VioFill(int x1, int y1, int x2, int y2, char caractere, char cor);
void VioFrame(int x1, int y1, int x2, int y2, char moldura, char cor);
void VioColor(int x1, int y1, int x2, int y2, char cor );
void VioSombra(int x1, int y1, int x2, int y2);
void VioSetView(int x1, int y1, int x2, int y2);

extern char color;