with Text_IO; use Text_IO;
procedure sel is

  N: constant := 10;

  task type Buffer is
    entry Append(I: in  Integer);
    entry Take  (I: out Integer);
  end Buffer;

  task body Buffer is
    B: array(0..N) of Integer;
    In_Ptr, Out_Ptr: Integer := 0;
    Count: Integer := 0;

  begin
    loop
      select
        when Count < N =>
          accept Append(I: in Integer) do
            B(In_Ptr) := I;
          end Append;
        Count := Count + 1;
        In_Ptr := (In_Ptr + 1) mod N;
      or
        when Count > 0 =>
         accept Take(I: out Integer) do
           I := B(Out_Ptr);
          end Take;
        Count := Count - 1;
        Out_Ptr := (Out_Ptr + 1) mod N;
      or
        terminate;
      end select;
    end loop;
  end Buffer;

  task Producer;
  task body Producer is
    N: Integer := 0;
  begin
    for I in 1..25 loop
      N := N + 1;
      Put("Produce  ");
      Put(N);
      New_Line;
      Buffer.Append(N);
    end loop;
  end Producer;

  task Consumer;
  task body Consumer is
    N: Integer;
  begin
    for I in 1..25 loop
      Buffer.Take(N);
      Put("Consume   ");
      Put(N);
      new_line;
    end loop;
  end Consumer;

begin
  Put_Line("Main program");
end sel;
