with Text_IO; use Text_IO;
procedure Peter is
  pragma Time_Slice(0.01);

  C1, C2: Integer := 1;
  Last:   Integer := 1;

  pragma Volatile(C1);
  pragma Volatile(C2);
  pragma Volatile(Last);

  task T1;
  task body T1 is
  begin
    loop
      Put_Line("Task 1 idling");
      C1 := 1;
      Last := 1;
      Put_Line("Task 1 trying to enter");
      loop exit when (C2 = 0)  or  (Last /= 1); end loop;
      Put_Line("Task 1 critical section");
      C1 := 0;
    end loop;
  end T1;

  task T2;
  task body T2 is
  begin
    loop
      Put_Line("Task 2 idling");
      C2 := 1;
      Last := 2;
      Put_Line("Task 2 trying to enter");
      loop exit when (C1 = 0) or (Last /= 2); end loop;
      Put_Line("Task 2 critical section");
      C2 := 0;
    end loop;
  end T2;

begin
  null;
end Peter;
