/* grafdemo.c

This program demonstrates the use of functions load_array(), scale(),
draw_perimeter(), and plot_curve().
With scale() and its associated functions,
truly device independent graphics programs can be written.

Dr. Jon Ahlquist, 24 July 1989, 13 Jan 1990.

Copyright 1990 by Jon Ahlquist, Department of Meteorology B-161,
Florida State University, Tallahassee, Florida 32306-3034, USA.
Telephone: (904) 644-1558.
Telnet address: ahlquist@metsat.met.fsu.edu (ahlquist@128.186.5.2)

This software may be freely copied without charge.
Copyright is made to prevent anyone from trying to impose restrictions
on this software.
All software and documentation is provided "as is" without warranty
of any kind.

Development of this material was sponsored by NSF grant ATM-8714674.
*/


/* Declare prototypes. */
#include <stdio.h>    /* printf(), getchar()   */
#include <conio.h>    /* getch()               */
#include <stdlib.h>   /* exit()                */
#include <graphics.h> /* All Borland graphics. */
#include <grafsupp.h> /* scale(), load_array(),
                         draw_perimeter(), plot_curve(),
                         and macros XX(), YY(), XG(), and YG(). */
#include <math.h>     /* cos()                 */

#define  NPTS 25
#define  PI    3.14159

void main(void)
{
int  graph_driver, graph_mode, graph_error, i;

float  time[NPTS],
       temperature[NPTS],
       xgmin, xgmax, ygmin,   ygmax,   /* Generic coordinate limits. */
       tmin,  tmax,  tempmin, tempmax; /* User    coordinate limits. */


/* Use any graphics mode that works with the user's computer. */

graph_driver = DETECT;
initgraph (&graph_driver, &graph_mode, "c:\\turboc");
if ((graph_error = graphresult())  <  0)
   {
   printf("Error while trying to initialize graphics.\n");
   printf("%s\n", grapherrormsg(graph_error));
   exit(1);
   }


/*   We'll use "generic" coordinates and "user" coordinates.

The vertical "generic" coordinate is 0 at the bottom of the user's
computer monitor screen and is 1 at the top of the screen.
In the horizontal direction, 0 to 1 runs from left to right,
is centered on the screen, and covers the same distance on the screen
that 0 to 1 covers vertically.
(With most video modes, pixels are not square, so the number of pixels
between 0 and 1 in the vertical direction is usually different
from the number of pixels between 0 and 1 in the horizontal direction.)

     "User" coordinates are whatever coordinates are convenient
for thinking about the data.
For this example, we'll assume that we want to plot temperature in degrees
Fahrenheit as a function of time in hours,
so  the horizontal user coordinate will be time in hours,
and the vertical   user cooridnate will be temperature in degrees.

function scale() establishes the transformation constants that
needed to place a graph of time versus temperature into a window
on the computer graphics screen.

Define a rectangular area on the monitor screen for our graph.
Horizontally, the rectangle will extend from
0.2 to 0.8 in terms of generic coordinates,
and the vertical range will be 0.3 to 0.7.
Our time range is 0 to 24 hours, and
the temperature range is 50 to 70 degrees Fahrenheit.
*/

/* Define a window in terms of generic coordinates. */
          ygmax = 0.7;
xgmin = 0.2;          xgmax = 0.8;
          ygmin = 0.3;

/* Define the user coordinates that will lie at the edges of the window. */
        tempmax = 70.;
tmin  = 0.;           tmax  = 24.;
        tempmin = 50.;

/* Establish constants needed to transform from generic and user
coordinates to pixel coordinates. */
scale(xgmin, xgmax, ygmin, ygmax, tmin, tmax, tempmin, tempmax);


/* Load the time array with uniformly spaced values. */
load_array(time, NPTS, tmin, tmax);

/* Load the temperature array. */
for (i=0; i< NPTS; i++)
   temperature[i] = 60. + 10 * cos(2.*PI*(time[i]-14.)/24.);

/* Write a title which starts at the left edge of the rectangular area
and sits just above it. */
label_plot("Time versus temperature", "Time in hours", "Temperature");
/*outtextxy (XG(xgmin), YG(ygmax+0.05), "Time in hours versus temperature");*/


/* Draw a box around the window, including tick marks. */
draw_perimeter(4, 6,  2, 10);

/* Plot the temperature.
If some array values exceed the limits used to define the window using scale(),
then some of the plot will lie outside the window. */
plot_curve(time, temperature, NPTS);

/* End the program. */
outtextxy(XG(0.0), YG(0.1), "Hit any key to end.");
getch();
closegraph();
} /* End of main(). */