program showdvm(input,output);

type
   headertype = array [0..2] of char;

const
   mustheader: headertype = 'DVM';

var
   ch: char;
   dtime: word;
   fi: file;
   fullqrt: char;
   header: headertype;
   infobyte, stepsize, version: byte;
   l: word;
   line: array [0..319] of byte;
   name: string;
   ofst, palsize: word;
   showit: boolean;
   palette: array [0..767] of byte;
   to_x: word;
   to_y: byte;
   vidmem: array [0..63999] of byte absolute $a000:$0000;
   lineoffset, work: word;
   x: word;
   y: byte;

procedure error(message: string; closefi: boolean);
begin
   if closefi then
      close(fi);
   writeln(message);
   halt;
end;

procedure setpalette(var palette; n: word);
var
	s, o: word;
begin
	s:=seg(palette);
   o:=ofs(palette);
	asm
  		mov ax,s
   	mov es,ax
   	mov ax,$1012
   	mov bx,$0000
   	mov cx,n
   	mov dx,o
   	int $10
	end;
end;

begin
   writeln('Show DVM Pascal');
	writeln('Written by Bert Greevenbosch for Magic Software Rotterdam',#10,#13,'Development Kit Version');
	writeln('Last possible DVM version: 4.0');
   if paramcount=0 then
      error('Syntax: SDP [Filename.DVM][/I]',false);
   assign(fi,'DVMPAL.BIN');
   {$i-}
   reset(fi,1);
   {$i+}
   if ioresult<>0 then
      error('Error opening DVMPAL.BIN',false);
   blockread(fi,palette,768);
   close(fi);
   name:=paramstr(1);
   showit:=false;
   if (copy(name,length(name)-1,2)='/I') or (copy(name, length(name)-1, 2)='/i') then
   begin
      name:=copy(name,1,length(name)-2);
      showit:=true;
   end;
   if paramstr(2)='/I' then
      showit:=true;
   assign(fi,name);
   {$i-}
   reset(fi,1);
   {$i+}
   if ioresult<>0 then
      error('Error opening file',false);
   blockread(fi,header,3);
   if header<>mustheader then
      error('Not a DVM',true);
   blockread(fi,fullqrt,1);
   case fullqrt of
      'F':
         infobyte:=$a0;
      'Q':
         infobyte:=$20;
      'V':
      begin
         blockread(fi,version,1);
         if version>$40 then
            error('Cannot display this version',true);
         blockread(fi,infobyte,1);
      end;
   end;
   blockread(fi,dtime,2);
   if infobyte and $08=$08 then
   begin
      blockread(fi, l, 2);
      for work:=1 to l do
      begin
         blockread(fi, ch, 1);
         if showit then
            write(ch);
      end;
      if showit then
      asm
         mov ah,$00
         int $16
      end;
   end;
   asm
      mov ax,$0013
      int $10
   end;
   case infobyte and $14 of
   	$14:
      begin
      	stepsize:=8;
         palsize:=2;
      end;
      $04:
      begin
      	stepsize:=4;
         palsize:=4;
      end;
      $00:
      begin
      	stepsize:=2;
         palsize:=16;
      end;
      $10:
      begin
      	stepsize:=1;
         palsize:=256;
      end;
   end;
   if infobyte and $40=0 then
   	stepsize:=1;
   if infobyte and $22=$22 then
   	blockread(fi, palette, palsize*3);
   setpalette(palette, 256);
   if infobyte and $80=$80 then
   begin
   	to_x:=320;
      to_y:=200;
   end
   else
   begin
   	to_x:=160;
      to_y:=100;
   end;
   repeat
      if infobyte and $22=$20 then
      begin
      	blockread(fi, palette, palsize*3);
         setpalette(palette, palsize);
      end;
      ofst:=0;
      y:=0;
      repeat
      	lineoffset:=0;
         blockread(fi, line, round(to_x/stepsize));
         x:=0;
      	repeat
            case stepsize of
            	1:
               	vidmem[ofst]:=line[lineoffset];
               2:
               begin
               	vidmem[ofst]:=(line[lineoffset] and $f0) shr 4;
                  vidmem[ofst+1]:=line[lineoffset] and $0f;
               end;
               4:
               begin
               	vidmem[ofst]:=(line[lineoffset] and $c0) shr 6;
                  vidmem[ofst+1]:=(line[lineoffset] and $30) shr 4;
                  vidmem[ofst+2]:=(line[lineoffset] and $0c) shr 2;
                  vidmem[ofst+3]:=line[lineoffset] and $03;
               end;
               8:
               	for work:=7 downto 0 do
                  	vidmem[ofst+7-work]:=(line[lineoffset] shr work) and $01;
            end;
            inc(lineoffset);
            inc(x, stepsize);
            inc(ofst, stepsize);
         until x=to_x;
         if x=160 then
         	inc(ofst, 160);
      	inc(y);
      until y=to_y;
   until eof(fi);
   close(fi);
   asm
      mov ah,$00
      int $16
      mov ax,$0003
      int $10
   end;
end.