program waterdvm(input, output);

uses
	dos;

const
	header: record
   	s: array [0..3] of char;
      version: byte;
      infobyte: byte;
      dtime: word;
   end=
   	(s: 'DVMV';
      version: $40;
      infobyte: $32;
		dtime: 83
   );
   maxx: longint=159;
   maxy: longint=99;
   noframes=128;

var
	c: byte;
   fi: file;
   ok: boolean;
   palette: array [0..255] of record
		red: byte;
		green: byte;
		blue: byte;
	end;
   v1: real;
   v2: real;
   vidmem: array [0..63999] of byte absolute $a000:$0000;
   work: byte;
   workr: real;
   x: longint;
   y: longint;

procedure putpixel(x, y: word; c: byte);
begin
	vidmem[x+y*320]:=c;
end;

begin
	writeln('WATERDVM');
   writeln('Written by Bert Greevenbosch for Magic Software Rotterdam');
	writeln('Will create the file WATER.DVM containing ', noframes,' frames');
   writeln(8+noframes*16000+768, ' bytes will be needed.');
   write('Ok to proceed (Y/N)? ');
   asm
   	xor ah,ah
      int $16
      cmp al,'a'
      jb @1
      cmp al,'z'
      ja @1
      sub al,32
   @1:cmp al,'Y'
   	jne @2
      mov ok,1
   	jmp @3
   @2:mov ok,0
   @3:
   end;
   if ok then
   	writeln('Y')
   else
   	writeln('N');
   if not ok then
   	halt;
	if diskfree(0)<8+noframes*16000+768 then
   begin
   	writeln('Not enough free space to create the DVM');
      halt;
   end;
	assign(fi, 'WATER.DVM');
   rewrite(fi, 1);
   blockwrite(fi, header, 8);
   for work:=0 to 63 do
   	with palette[work] do
      begin
      	red:=0;
         green:=0;
         blue:=work;
      end;
   for worK:=64 to 255 do
   	with palette[work] do
      begin
      	red:=0;
         green:=0;
         blue:=0;
      end;
   asm
   	mov ax,$0013
      int $10
      mov ax,$1012
		xor bx,bx
   	mov cx,$0040
      mov si,seg palette
      mov es,si
      mov dx,offset palette
      int $10
   end;
   workr:=0;
   blockwrite(fi, palette, 768);
   repeat
   	for x:=0 to maxx do
   		for y:=0 to maxy do
      	begin
				v1:=sqrt(sqr(maxx-x)+sqr(maxy-y))
			   	/sqrt(sqr(maxx  )+sqr(maxy  ));
				v2:=sqrt(sqr(x     )+sqr(maxy-y))
			   	/sqrt(sqr(maxx  )+sqr(maxy  ));
         	c:=trunc(15.75*(2+
					v1*sin((8*pi/maxy)*
					(sqrt(sqr(     x)+sqr(y))-workr))+
            	v2*sin((8*pi/maxy)*
					(sqrt(sqr(maxx-x)+sqr(y))-workr))
				));
         	putpixel(x, y, c);
         end;
      workr:=workr+maxy/(noframes-1);
      for work:=0 to 99 do
      	blockwrite(fi, vidmem[work*320], 160);
   until workr>maxy;
   close(fi);
   asm
      mov ax,$0003
      int $10
   end;
end.