// ******************************************************************** //
//                                                                      //
//  VIEW.CPP                                                            //
//  Copyright (c) 1994, Bob Flanders and Michael Holmes                 //
//                                                                      //
//  This module contains the routines to view the directory of a        //
//  ZIP file and the routines common to processing the base ZIP         //
//  file and the compressed files one at a time.                        //
//                                                                      //
// ******************************************************************** //


/* ******************************************************************** *
 *
 *  zip_select_file() -- determine if this file should be processed
 *
 *  Returns: TRUE = file should be processed
 *          FALSE = file should be bypassed
 *
 * ******************************************************************** */

int     zip_select_file(void)
{
int     i;                                  // loop control variables


if (sw_exclude &&                           // q. any excluded files?
        select_file(&wf, &ef))              // ..and this one?
    return(FALSE);                          // a. yes .. rtn not selected

if (NOT sf_count)                           // q. selection list used?
    return(TRUE);                           // a. no .. everything is ok

for (i = 0; i < sf_count; i++)              // loop thru selection list
    if (select_file(&wf, &sf[i]))           // q. use this file?
        return(TRUE);                       // a. yes .. return selected

return(FALSE);                              // if not in, they're out

}



/* ******************************************************************** *
 *
 *  view_zip() -- view a ZIP file's directory
 *
 *  This routine is a sub-function of the scan_zip() routine.  The
 *  view_zip() routine is call with the following function calls.
 *
 *      0 = initialization call
 *      1 = current file number
 *      2 = completion call
 *
 * ******************************************************************** */

void    view_zip(int fnc,                   // function
                 LF *lfp)                   // local file header pointer
{
static
BYTE    ef = 0;                             // encrypted file seen


switch (fnc)                                // based on function number
    {
    case 0:                                 // initialization call
        printf(view_hdr, zfn);              // print header information
        break;                              // ..and return to caller

    case 1:                                 // process file call
        fseek(ifile, lfp->lf_csize,         // seek past compressed data
            SEEK_CUR);

        if (NOT zip_select_file())          // q. bypass this file?
            break;                          // a. yes .. skip this one

        printf(view_line,                   // print detail line
            lfp->lf_size,                   // ..uncompress size
            compress[lfp->lf_cm < 9 ?       // ..compression method
                    lfp->lf_cm + 1 : 0],    // ..or unknown if unsupported
            lfp->lf_csize,                  // ..compressed size
            ratio(lfp->lf_size,             // ..compression ratio
                    lfp->lf_csize),
            file_date(lfp->lf_date,         // ..file date and time
                    lfp->lf_time),
            lfp->lf_flag & LH_FLAG_ENCRYPT  // ..encrypted file marker
                ? '' : ' ',
            strlen(wf.path) > 32 ?          // ..handle long filenames
                    view_nextline : "",
            wf.path);                       // ..filename

        ef |= lfp->lf_flag & LH_FLAG_ENCRYPT;   // encrypted file seen
        total_files++;                          // tally processed files
        total_size += lfp->lf_size;             // summarize uncompressed
        total_csize += lfp->lf_csize;           // ..and compressed sizes
        break;                                  // finally, return to caller

    case 2:                                 // completion call
        if (total_files)                    // q. any files printed?
            printf(view_trailer,            // print trailer message
                total_size, "",             // ..with total file sizes
                total_csize,                // ..and total compressed
                ratio(total_size,           // ..overall compression ratio
                            total_csize),
                "", total_files,            // ..total file count
                ef ? view_encrypt : "");    // ..and encrypt message
         else
            printf(view_none);              // else .. tell about nothing
        break;                              // ..then return to caller
    }
}



/* ******************************************************************** *
 *
 *  read_lf() -- read in the remains of a local file header record
 *
 * ******************************************************************** */

void    read_lf(LF *lfp)
{
char   *p = wf.path;                        // work string pointer


fread(&lfp->lf_extract,                     // read in remains of record
            sizeof(struct lf) - 4, 1, ifile);

fread(p, lfp->lf_fn_len, 1, ifile);         // ..and filename
p[lfp->lf_fn_len] = 0;                      // terminate filename string

for (; *p; p++)                             // loop thru filename string
    if (*p == '/')                          // q. unix style dir separator?
        *p = '\\';                          // a. yes .. fix for MSDOS

SPLIT(wf);                                  // split filename into pieces

if (lfp->lf_ef_len)                         // q. any extra field data?
    fseek(ifile, lfp->lf_ef_len, SEEK_CUR); // a. yes .. seek past data

}



/* ******************************************************************** *
 *
 *  read_fh() -- read in the remains of a file header record
 *
 * ******************************************************************** */

void    read_fh(FH *fhp)
{

fread(&fhp->fh_made,                        // read in remains of record
            sizeof(struct fh) - 4, 1, ifile);
fseek(ifile, fhp->fh_fn_len, SEEK_CUR);     // seek past filename

if (fhp->fh_ef_len)                         // q. any extra field data?
    fseek(ifile, fhp->fh_ef_len, SEEK_CUR); // a. yes .. seek past data

if (fhp->fh_fc_len)                         // q. any file comments?
    fseek(ifile, fhp->fh_fc_len, SEEK_CUR); // a. yes .. seek past data

}



/* ******************************************************************** *
 *
 *  read_ed() -- read in the remains of the end of central dir record
 *
 * ******************************************************************** */

void    read_ed(ED *edp)
{


fread(&edp->ed_disk,                        // read in remains of record
            sizeof(struct ed) - 4, 1, ifile);

if (edp->ed_zc_len)                         // q. any zip file comments?
    fseek(ifile, edp->ed_zc_len, SEEK_CUR); // a. yes .. seek past data

}



/* ******************************************************************** *
 *
 *  scan_zip() -- scan a ZIP file's directory
 *
 * ******************************************************************** */

void    scan_zip(void (*proc)(int, LF *))   // rtn to process each dir entry
{
char   *b;                                  // work buffer pointer
LF     *lfp;                                // local file header pointer


b = (char *) malloc_chk(1024);              // allocate some memory
lfp = (LF *) b;                             // ..and set up pointer

proc(0, lfp);                               // make init call

for (; NOT feof(ifile);)                    // loop till end of file
    {
    if (fread(b, 4, 1, ifile) != 1)         // q. read a sig ok?
        break;                              // a. no .. exit loop

    if (*(int *) b != 0x4b50)               // q. 'PK' zip signature?
       continue;                            // a. no .. try again

    if (*(int *) &b[2] == LF_SIG)           // q. local file header rec?
        {
        read_lf(lfp);                       // a. yes .. get record
        proc(1, lfp);                       // call processing routine
        }

     else if (*(int *) &b[2] == FH_SIG)     // q. file header record?
        read_fh((FH *) b);                  // a. yes .. get record

     else if (*(int *) &b[2] == ED_SIG)     // q. end of central dir rec?
        read_ed((ED *) b);                  // a. yes .. get record
    }

proc(2, lfp);                               // competion call to proc rtn
free(b);                                    // finally, release memory

}
