/******************************************************************************
 *
 *    Syntax:
 *
 *	 PKZDATE Zip1[.ZIP] Zip2[.ZIP] Zip3.[ZIP]
 *
 *    Updates:
 *
 ******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <alloc.h>
#include <conio.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <bios.h>
#include <dir.h>
#include <dos.h>
#include <io.h>
#include <share.h>
#include <fcntl.h>
#include "pkzip.h"

#define RELEASE_LEVEL	"0.03"

/* Global variables */

struct ZIPSTATS
  {
  int  Handle;
  long FilePos;
  struct CENTRAL_RECORD *CDRTable;
  struct END_CENTRAL_RECORD *ECDPtr;
  struct CENTRAL_RECORD *CurCDROff;
  char Name[64];
  };

struct ZIPSTATS Zip;
int	RecurseSubdirs;
static int   TotalZips;

/* Function prototypes */

extern	int main99(int argc, char * *argv);

int main(int argc, char *argv[])
{
int   rc;

  rc = main99(argc, argv);
  return(rc);
}

void DisplayError(int ErrorType)
{
  switch (ErrorType)
    {
    case -1:
      printf("\nPKZDATE %s (TC 2.0L) - Latest File Dater", RELEASE_LEVEL );
      printf("\n\nSyntax: PKZDATE Zip1[.ZIP] Zip2[.ZIP] .... ....");
      printf("\n - Zipnames can be up 63 chars in length");
      printf("\n - # of Zips limited only by command line length");
      printf("\n - DOS d:[\path\]filename.ext fully supported");
      printf("\n - Wildcards ok");
      printf("\n - /S or -S to search all subdirs below specified one");
      printf("\n");
      printf("\nReturn Codes:");
      printf("\n   0 - Successful completion");
      printf("\n 255 - Help Screen / Incorrect parms specified");
      printf("\n   1 - Unable to OPEN Zip");
      printf("\n   2 - Unable to LSEEK in Zip");
      printf("\n   3 - Unable to READ Zip");
      printf("\n   4 - Unable to WRITE Zip");
      printf("\n   5 - Unable to ALLOCATE for Zip");
      printf("\n   6 - Unable to CREATE Zip");
      printf("\n");
      break;
    case 1:
      printf("\nCannot open: ");
      break;
    case 2:
      printf("\nNot able to LSEEK in: ");
      break;
    case 3:
      printf("\nNot able to READ in: ");
      break;
    case 4:
      printf("\nNot able to WRITE in: ");
      break;
    case 5:
      printf("\nOut of memory in: ");
      break;
    case 6:
      printf("\nUnable to CREATE file: ");
      break;
    }

  if (ErrorType >= 0)
    {
    printf("%s", Zip.Name);
    }
  else
    exit( ErrorType );
}

int OpenZipFile( void )
{

  if(_osmajor >= 3)
    Zip.Handle = sopen(Zip.Name, O_RDONLY | O_BINARY, SH_DENYWR, S_IREAD);
  else
    Zip.Handle = open(Zip.Name, O_RDONLY | O_BINARY);

  if(Zip.Handle == -1)
    {
    DisplayError(2);
    return(2);
    }

  return(0);
}

long LseekZip( long FilePos )
{
long rc, bytes2move;

  Zip.FilePos = tell( Zip.Handle );
  bytes2move = FilePos - Zip.FilePos;

  rc = lseek( Zip.Handle, bytes2move, SEEK_CUR );
  if ( rc <= -1L )
    {
    DisplayError(2);
    return(2);
    }
  Zip.FilePos = rc;

  return(0);
}

int ReadZip( char *ReadBuf, int ReadSize )
{
int BytesRead;

  BytesRead = _read( Zip.Handle, ReadBuf, ReadSize );
  if ( BytesRead != ReadSize )
    {
    DisplayError(3);
    return(3);
    }

  Zip.FilePos += ReadSize;

  return(0);
}

int WriteZip( char *WriteBuf, int WriteSize )
{
int BytesWritten;

  BytesWritten = _write( Zip.Handle, WriteBuf, WriteSize );
  if ( BytesWritten != WriteSize )
    {
    DisplayError(4);
    return(4);
    }

  Zip.FilePos += WriteSize;

  return(0);
}

int FindZipCentralDir( void )
{
int rc, break_flag, loop_counter, ZipCmtLngth;
char Buffer[sizeof(struct END_CENTRAL_RECORD)];
long *MatchPtr;
long EndRecordOffset;
long ReadSize, LseekSize;
long allocate_size;

  Zip.FilePos = lseek(Zip.Handle, 0L, SEEK_END);
  if ( Zip.FilePos == -1 || Zip.FilePos < sizeof(struct END_CENTRAL_RECORD) )
    {
    DisplayError(2);
    return(2);
    }

  ReadSize = (long)sizeof(struct END_CENTRAL_RECORD);
  LseekSize = ReadSize;

  LseekZip( Zip.FilePos - ReadSize );

  /* Read 1st block into memory */

  ReadZip( (char *)Buffer, (int)ReadSize );

  while(1)
    {
    break_flag = 0;
    loop_counter = 0;
    for (MatchPtr = (long *)Buffer; MatchPtr < (long *)(Buffer + (int)ReadSize); ((char *)MatchPtr)++)
      {
      if (*MatchPtr == ENDCENTRALSIG )
	{
	break_flag = 1;
	break;
	}
      loop_counter++;
      }

    if (break_flag)
      break;

    /* Move 1st 3 bytes to end of buffer */

    for (rc = 0; rc < 3; rc++)
      Buffer[sizeof(struct END_CENTRAL_RECORD) - 3 + rc] = Buffer[rc];

    ReadSize = (long)(sizeof(struct END_CENTRAL_RECORD) - 3);

    LseekZip( Zip.FilePos -(ReadSize + LseekSize) );

    LseekSize = ReadSize;

    /* Read next block into memory */

    ReadZip( (char *)Buffer, (int)ReadSize );
    }

  EndRecordOffset = Zip.FilePos + loop_counter - ReadSize;

  LseekZip( EndRecordOffset + sizeof(struct END_CENTRAL_RECORD) -
     sizeof(int) );

  ReadZip( (char *)&ZipCmtLngth, sizeof(int) );

  allocate_size = (long)(sizeof(struct END_CENTRAL_RECORD) + ZipCmtLngth);
  Zip.ECDPtr = (struct END_CENTRAL_RECORD *)calloc( (int)allocate_size, 1 );
  if ( Zip.ECDPtr == NULL )
    {
    DisplayError(5);
    return(5);
    }

  LseekZip( EndRecordOffset );

  ReadSize = allocate_size;

  /* Read ECR into memory */

  ReadZip( (char *)Zip.ECDPtr, (int)ReadSize );

#if 0
  printf("\n%s -> Located ECR at offset %ld!", Zip.Name,
     EndRecordOffset);
  printf("\n%s -> Central Dir at offset %ld has %d entries occupying %d bytes!",
     Zip.Name,
     Zip.ECDPtr->CentralDirOffset,
     Zip.ECDPtr->CentralDirEntries,
     Zip.ECDPtr->CentralDirSize );
#endif
  return(0);
}

int LoadCentralDir( void )
{
long allocate_size;
char *CharPtr;

  allocate_size = Zip.ECDPtr->CentralDirSize;
  Zip.CDRTable =
     (struct CENTRAL_RECORD *)calloc( (int)allocate_size, 1 );
  if ( Zip.CDRTable == NULL )
    {
    DisplayError(5);
    return(5);
    }

  LseekZip( Zip.ECDPtr->CentralDirOffset );

  CharPtr = (char *)Zip.CDRTable;
  ReadZip( CharPtr, (int)allocate_size );

  return(0);
}

int FindLatestDate( struct ftime *ft )
{
struct CENTRAL_RECORD *SourceCDR;
int rc, SourceCD;
unsigned LatestDate, LatestTime;

  rc = LatestDate = LatestTime = 0;
  for (SourceCD = 0; SourceCD < Zip.ECDPtr->CentralDirEntries; SourceCD++)
    {

    if (SourceCD == 0)
      SourceCDR = Zip.CDRTable;
    else
      (char *)SourceCDR += ( SIZECDR + SourceCDR->CommentFieldLength +
	  SourceCDR->FileNameLength );

    Zip.CurCDROff = SourceCDR;

    if ( SourceCDR->FileDate > LatestDate )
      {
      LatestDate = SourceCDR->FileDate;
      LatestTime = SourceCDR->FileTime;
      }
    else
      {
      if ( SourceCDR->FileDate == LatestDate )
	{
	if ( SourceCDR->FileTime > LatestTime )
	  {
	  LatestDate = SourceCDR->FileDate;
	  LatestTime = SourceCDR->FileTime;
	  }
	}
      }
    }
  ft->ft_tsec  = LatestTime & 0x1f;
  ft->ft_min   = ( LatestTime & 0x7e0 ) >> 5;
  ft->ft_hour  = ( LatestTime & 0xf800 ) >> 11;
  ft->ft_day   = LatestDate & 0x1f;
  ft->ft_month = ( LatestDate & 0x1e0 ) >> 5;
  ft->ft_year  = ( LatestDate & 0xfe00 ) >> 9;

  return( rc );
}

int SetLatestZipDate( char *ZipName )
{
int rc;
struct ftime ftimep;

  rc = 0;

  strcpy( Zip.Name, ZipName );

  rc = OpenZipFile();
  if ( !rc )
    {
    rc = FindZipCentralDir();
    if ( !rc )
      {
      rc = LoadCentralDir();
      if ( !rc )
	{
	FindLatestDate( &ftimep );
	setftime( Zip.Handle, &ftimep );
	TotalZips++;
	printf( "\nDated->%s.", Zip.Name );
	}
      free( Zip.CDRTable );
      }
    close( Zip.Handle );
    }

  return( rc );
}

ProcessFile(char *FileMask)
{
  struct   ffblk c_file;
  char	   full_file[65];
  int	   rc;
  char	   Drive[3];
  char	   Path[65];
  char	   Fname[13];
  char	   Ext[5];
  unsigned AttributeMask;

  fnsplit( FileMask, Drive, Path, Fname, Ext );

  if ( Fname == NULL )
    return(1);

  rc = 0;
  AttributeMask = FA_ARCH;
  if ( !findfirst( FileMask, &c_file, AttributeMask ) )
    {
    do
      {
      strcpy( full_file, Drive );
      strcat( full_file, Path );
      strcat( full_file, c_file.ff_name );
      SetLatestZipDate( full_file );
      if ( kbhit() )
	break;
      } while ( findnext( &c_file ) == 0 );
    }

  if ( RecurseSubdirs )
    {
    strcpy( full_file, Drive );
    strcat( full_file, Path );
    strcat( full_file, "*.*" );

    AttributeMask = FA_DIREC;
    if ( !findfirst( full_file, &c_file, AttributeMask ) )
      {
      do
	{
	if ( strcmpi( c_file.ff_name, ".") != 0 &&
	   strcmpi( c_file.ff_name, ".." ) != 0 )
	  {
	  strcpy( full_file, Drive );
	  strcat( full_file, Path );
	  strcat( full_file, c_file.ff_name );
	  strcat( full_file, "\\" );
	  strcat( full_file, Fname );
	  strcat( full_file, Ext );
	  ProcessFile( full_file );
	  if ( kbhit() )
	    break;
	  }
	} while ( findnext( &c_file ) == 0 );
      }
    }

  return(rc);
}

void ParseSwitchesOffCommandline( int argc, char *argv[] )
{
int index;

  for( index = 1; index < argc; index++)
    {
    strupr( argv[ index ] );
    if ( *argv[ index ] == '-' || *argv[ index ] == '/' )
      {
      switch( argv[ index ][ 1 ] )
	{
	case 'S':
	  RecurseSubdirs++;
	  argv[ index ] = NULL;
	  break;
	}
      }
    }
}

int main99(int argc, char *argv[])
{
int rc, loop_counter;
char FileMask[64];

  rc = 0;
  if( argc < 2 )
    DisplayError(-1);

  ParseSwitchesOffCommandline( argc, argv );

  printf("\nPKZDATE %s - Zip File Dater", RELEASE_LEVEL );
  printf("\n - processing %d filemask(s) ....\n", argc - 1);

  TotalZips = 0;
  for (loop_counter = 1; loop_counter < argc; loop_counter++)
    {

    if ( strlen( argv[ loop_counter ] ) > 63 )
      DisplayError(-1);

    strcpy( FileMask, argv[ loop_counter ] );
    strupr( FileMask );

    /* If the .ZIP extension is missing add it. */

    if ( strchr( FileMask, '.') == NULL )
      strcat( FileMask, ".ZIP" );

    ProcessFile( FileMask );
    }

  printf("\n%d Zip(s) dated.\n", TotalZips );

  return(rc);
}

