;-----------------------------------------------------------------------------
; VGA status port

STATUS          = 03DAh ; status register port

IS_HVSYNC       = 01
IS_VSYNC        = 08

;-----------------------------------------------------------------------------
; Programmable Interrupt Timer  (PIT) chip 8253

;PIT data ports
PIT0 = 40h ; channel 0, its output is connected to the IRQ0 input
PIT1 = 41h ; channel 1, do nor use this, on AT was used to refresh dram
PIT2 = 42h ; channel 2, can be connected to the pc-speaker 
;PIT control port
PIT_CTRL = 43h 

; COMMAND WORDS (actually bytes)
;
; bit         7     6           5       4        3   2   1       0
; value    counter_select    read_write_latch   counter_mode    bcd_on

T_SET0 = 036h ; channel 0, square wave, READ/WRITE COUNT INTERVAL
              ; LSB then MSB on data port
              ; this is the standard way to reprogram the IRQ frequency
              ; or to read the programmed time count value
              
              
T_LATCH0 = 000h ; channel 0, LATCH counter (read current count value)
                ; then  if the timer channel was programmed with two bytes
                ;               first LSB, then MSB
                ;       else
                ;               read byte
                ;       end if
                ; this is the standard way to "read on the flight"
                ; what's the current counter value (NOT the count interval)

              
T_SET2 = 0B6h ; channel 2, square wave, read/write LSB then MSB on data port
              ; use this to make the pc speaker buzz
              ; but remember to connect the channel 2 output to speaker output
              
;------------------------------------------------------------------------------
; Programmable Interrupt Controllers                  

; Master PIC: IRQ0..IRQ7 ( IRQ2 chains slave PIC)
PIC0_CTRL = 020h
PIC0_DATA = 021h
; PIC0_DATA is a irq control mask for irqs 0..7
; (if bit n is set to 1 the corresponding irq line is inhibited)
; BIT   IRQ   USAGE
;   0     0   timer interrupt
;   1     1   keyboard controller
;   2     2   cascade from slave PIC (PIC1) , on XT was the vretrace irq
;   3     3   com2 (usually free on single serial port systems)
;   4     4   com1
;   5     5   printer port 2 (was hard disk irq on XT systems) (usually free)
;   6     6   floppy disk
;   7     7   printer port 1 (usually free, most software uses polling)
;  N.B. most of the old cards (or new cards with old software drivers)
;       needs an irq ranging from 0 to 7 (because the upper irqs works
;       only with 16bit cards and the irq acknowledge sequence
;       is different for irq 8..15).

; Slave PIC: IRQ8..IRQF ( IRQ9 is the "alias" for the original unchained IRQ2
; found on pc-xt , so if you set a board on IRQ2 it will use IRQ9)
PIC1_CRTL = 0A0h
PIC1_DATA = 0A1h
; PIC1_DATA is a irq control mask for irqs 8..15
; (if bit n is set to 1 the corresponding irq line is inhibited)
; BIT   IRQ   USAGE
;   0     8   realtime clock
;   1     9   redirected vertical retrace (was irq2 on old XT systems)
;   2    10   <free>
;   3    11   <free>
;   4    12   mouse irq ( used by non-serial-port mouses)
;   5    13   coprocessor exception
;   6    14   AT hard disk irq
;   7    15   <free>
;   N.B  <free> means available to other expansion boards
;        (i.e. sound boards, scanners or who-knows-what)
;

; to "terminate" an IRQ request on the PIC you must send to
; the control ports ....
EOI  = 020h ; End Of Interrupt (activates the next irq pending on another line)
SEOI = 060h ; Specific End Of Interrupt (use this to avoid overruns)
            ; if there are overruns send 
            ; (SEOI+(IRQ_number mod 8)) instead of a plain EOI
            
; to terminate an irq request on PIC1 you must FIRST
; send an EOI to PIC0 (because PIC1 chains PIC0 using IRQ2)
; and then terminate the irq on PIC1

