;
; Small bumpmapper by Kurt Inge Groenbech
; Sample file for Alab v1.3.
; Didn't bother to fix the bug in the screen edges.
;

; uncomment this macro if you assemble with Tasm v3.2 or higher, and use /w0.
;PROC    MACRO   name
;        name PROC
;ENDM

;USEMOUSE        equ     0               ; uncomment if you want to use mouse

code    Segment byte public 'code'
        .386
        locals
        Assume cs:code, ds:code
        Org 100h

Start:
        mov     ah, 4ah
        mov     bx, sp                  ; points to end of segment (cs:fffeh)
        shr     bx, 4                   ; divides by 16
        add     bx, 2                   ; + 2 so we have some margine
        int     21h

        mov     bx, 4096
        mov     ah, 48h
        int     21h                     ; allocate 64k buffer
        mov     fs, ax

        mov     bx, 4096
        mov     ah, 48h
        int     21h                     ; allocate 64k buffer
        mov     gs, ax

        push    cs
        pop     ds
        push    0a000h
        pop     es                      ; es always points to vram

        mov     dx, offset startmessy
        mov     ah, 9
        int     21h

        call    clearbuffer
        call    calcbackground

; put "Alab v1.3" on top of generated background
        mov     cx, textlen/2
        mov     si, offset text
@@m:
        mov     di, cs:[si]
        add     byte ptr fs:[di], 30;35
        add     si, 2
        dec     cx
        jnz     @@m

        call    smooth                  ; smooths the picture

        mov     ax, 13h
        int     10h

; set palette
;        mov     dx, 3c8h
;        mov     al, 0
;        out     dx, al
;        inc     dx
;        mov     si, offset [palette]
;        mov     cx, 256*3
;        rep     outsb
;        jmp     past

        mov     dx, 3c8h
        mov     al, 0
        out     dx, al
        inc     dx
        mov     cx, 64
        mov     ah, 0
@@setpal:
        rept 4
        xor     al, al
        out     dx, al
        out     dx, al
        mov     al, ah
        out     dx, al
        endm
        inc     ah
        loop    @@setpal
;past:

ifdef USEMOUSE
        mov     ax, 0
        int     33h                     ; initialize mouse
else
        mov     [centerx], 160
        mov     [centery], 100
        mov     [xinc], 6
        mov     [yinc], 4
endif

;------ draw loop --------------------------------------------------------
; check out flc_bump.zip by The Flower Corp., where this code is taken from
; just a few adjustements have been made.
@@draw:
ifdef USEMOUSE
        mov     ax, 0003h
        int     33h                     ; get mouse x and y pos (cx,dx)
else
        mov     cx, [centerx]
        mov     dx, [centery]
endif
        mov     [mousex], cx            ; store mouse x pos

        mov     di, 321                 ; start at (1,1)
        mov     ax, 1
        sub     ax, dx                  ; -mousey
        mov     [ly], ax                ; store light normal ycoordinate

        mov     word ptr [i], 198       ; y counter (lines on screen)

@@boucle_Y:
        mov     ax, 1
        sub     ax, [mousex]
        mov     [lx], ax                ; store light normal xcoordinate

        mov     word ptr [j], 318       ; x counter (horizontal pixels)

@@boucle_X:
;        mov     ax, word ptr fs:[2]     ; get from map
;        mov     es, ax
        xor     bx, bx
        xor     ax, ax
        mov     al, fs:[di+1]
        mov     bl, fs:[di-1]
        sub     ax, bx
        mov     [x], ax

        xor     ax, ax
        mov     al, fs:[di+320]
        mov     bl, fs:[di-320]
        sub     ax, bx
        mov     [y], ax

        inc     [lx]

        mov     ax, [x]  ; {calcul de coul1:x}
        sub     ax, [lx]
        cwd       ; abs(ax)
        xor     ax, dx
        sub     ax, dx
        mov     bx, 128
        sub     bx, ax
        cmp     bx, 0
        jg      @@lapin
        mov     bx, 0
@@lapin:

        mov     ax, [y]  ;{coul2}
        sub     ax, [ly]
        cwd
        xor     ax, dx
        sub     ax, dx
        mov     cx, 128
        sub     cx, ax
        cmp     cx, 0
        jg      @@elephant
        mov     cx, 0
@@elephant:

        mov     ax, bx ;{coul1*coul2}
        mul     cx
        mov     bx, 64
        div     bx
        cmp     ax, 255
        jbe     @@girafe
        mov     ax, 255
@@girafe:
;        mov     bx, word ptr celine[2]
;        mov     es, bx
;        mov     es:[di], al
        mov     gs:[di], al
        inc     di

        dec     [j]
        jnz     @@boucle_X

        inc     [ly]

        add     di,2
        dec     [i]
        jnz     @@boucle_Y

        mov     ax, [xinc]
        add     [centerx], ax
        cmp     [centerx], 300
        jng     @@xok1
        neg     [xinc]
@@xok1:
        cmp     [centerx], 20
        jg      @@xok2
        neg     [xinc]
@@xok2:
        mov     ax, [yinc]
        add     [centery], ax
        cmp     [centery], 180
        jng     @@yok1
        neg     [yinc]
@@yok1:
        cmp     [centery], 20
        jg      @@yok2
        neg     [yinc]
@@yok2:
        ; show
        call    buf2screen
        ;
        mov     ah, 1
        int     16h
        jz     @@draw
        mov     ah, 0
        int     16h                     ; swollow keystroke
;------

        mov     ax, 3
        int     10h

        ret

; procedure ripped from some intro which Jmagic made if I remember correctly.
; a few adjustements
PROC    calcbackground
        push    gs
        mov     ax, 40h
        mov     gs, ax
        mov     di, 0
        mov     bp, 0
        mov     si,0
        xor     ecx,ecx
        mov     bx, 15  ; husk! hva skal jeg ha her?
@@1:
        mov     al,fs:[bp]
        inc     bp
        test    al,1
        jne     @@2
        add     di,1
@@2:
;        add     di,325
        movzx   ax, byte ptr gs:[6ch]
        add     di, ax
        inc     bp
;        inc     bp
        and     al, 3
;        inc     byte ptr fs:[di]
        add     byte ptr fs:[di], al
        dec     cx
        jnz     @@1
        dec     bx
        jnz     @@1
        pop     gs
        ret
ENDP

PROC    smooth
        mov     dx,200
@@1:
        mov     cx,320
@@2:
        mov     al,fs:[si-320]
        add     al,fs:[si-1]
        add     al,fs:[si+1]
        add     al,fs:[si+320]
        shr     al,2
        mov     fs:[si],al
        inc     si
        dec     cx
        jnz     @@2
;        add esi,2
        dec     dx
        jnz     @@1
        ret
ENDP

clearbuffer PROC
        push    es

        push    fs
        pop     es
        xor     di, di
        xor     eax, eax
        mov     cx, 64000/4
        rep     stosd

        pop     es
        ret
ENDP

buf2screen PROC
        push    ds

        push    gs
        pop     ds
        xor     si, si
        xor     di, di
        mov     cx, 64000/4
        rep     movsd

        pop     ds
        ret
ENDP

comment &
label Palette byte
 ri = 0
 rept 18
  db 0,0,ri*2
  ri=ri+1
 endm

 ri = 30
 rept 63
  db 0,0,ri
  db 0,0,ri
  ri = ri + 1
 endm
&

startmessy      db      'Small bump mapping example by Kurt Inge Groenbech.',13,10
                db      'Based on bump mapping by Phar/Flower Corp.',13,10,10
                db      'Making bump map...$'

text            label   byte
dw   24813, 25131, 25132, 25385, 25386, 25387, 25388, 25389, 25390, 25391, 25392, 25393, 25394, 25395, 25396, 25397
dw   25398, 25399, 25446, 25447, 25448, 25449, 25450, 25451, 25452, 25453, 25454, 25455, 25480, 25481, 25482, 25483
dw   25484, 25485, 25486, 25487, 25488, 25489, 25490, 25687, 25703, 25704, 25710, 25711, 25712, 25713, 25714, 25715
dw   25750, 25763, 25764, 25765, 25770, 25771, 25772, 25776, 25777, 25778, 25798, 25799, 25800, 25807, 25808, 25809
dw   25815, 25816, 26006, 26007, 26022, 26031, 26032, 26033, 26034, 26069, 26070, 26081, 26082, 26090, 26091, 26092
dw   26098, 26099, 26100, 26116, 26117, 26118, 26126, 26127, 26128, 26134, 26135, 26136, 26137, 26146, 26147, 26148
dw   26163, 26164, 26165, 26166, 26167, 26168, 26169, 26326, 26327, 26341, 26351, 26352, 26353, 26354, 26389, 26390
dw   26400, 26401, 26409, 26410, 26411, 26412, 26419, 26420, 26421, 26435, 26436, 26437, 26446, 26447, 26448, 26453
dw   26454, 26455, 26456, 26457, 26458, 26465, 26466, 26467, 26468, 26482, 26483, 26484, 26485, 26486, 26487, 26488
dw   26489, 26645, 26646, 26647, 26660, 26661, 26671, 26672, 26673, 26674, 26708, 26709, 26710, 26719, 26720, 26729
dw   26730, 26731, 26732, 26740, 26741, 26755, 26756, 26757, 26765, 26766, 26767, 26773, 26774, 26775, 26776, 26777
dw   26778, 26779, 26784, 26785, 26786, 26787, 26788, 26801, 26802, 26803, 26804, 26805, 26806, 26807, 26808, 26965
dw   26966, 26967, 26968, 26980, 26991, 26992, 26993, 26994, 27028, 27029, 27030, 27031, 27039, 27049, 27050, 27051
dw   27052, 27060, 27061, 27062, 27074, 27075, 27076, 27085, 27086, 27087, 27092, 27095, 27096, 27097, 27098, 27099
dw   27106, 27107, 27108, 27120, 27126, 27127, 27284, 27285, 27286, 27287, 27288, 27299, 27300, 27311, 27312, 27313
dw   27314, 27347, 27348, 27349, 27350, 27351, 27358, 27359, 27369, 27370, 27371, 27372, 27380, 27381, 27382, 27394
dw   27395, 27396, 27404, 27405, 27406, 27407, 27412, 27416, 27417, 27418, 27419, 27420, 27426, 27427, 27428, 27440
dw   27446, 27604, 27606, 27607, 27608, 27619, 27620, 27631, 27632, 27633, 27634, 27667, 27669, 27670, 27671, 27678
dw   27679, 27689, 27690, 27691, 27692, 27700, 27701, 27702, 27714, 27715, 27716, 27724, 27725, 27726, 27737, 27738
dw   27739, 27740, 27746, 27747, 27748, 27765, 27923, 27926, 27927, 27928, 27939, 27940, 27951, 27952, 27953, 27954
dw   27986, 27989, 27990, 27991, 27998, 27999, 28009, 28010, 28011, 28012, 28020, 28021, 28022, 28034, 28035, 28036
dw   28044, 28045, 28046, 28057, 28058, 28059, 28060, 28061, 28066, 28067, 28068, 28084, 28242, 28246, 28247, 28248
dw   28249, 28259, 28260, 28261, 28271, 28272, 28273, 28274, 28305, 28309, 28310, 28311, 28312, 28318, 28319, 28329
dw   28330, 28331, 28332, 28339, 28340, 28341, 28354, 28355, 28356, 28363, 28364, 28365, 28366, 28378, 28379, 28380
dw   28381, 28386, 28387, 28388, 28403, 28562, 28566, 28567, 28568, 28569, 28580, 28581, 28588, 28591, 28592, 28593
dw   28594, 28625, 28629, 28630, 28631, 28632, 28638, 28639, 28640, 28649, 28650, 28651, 28652, 28658, 28659, 28660
dw   28674, 28675, 28676, 28683, 28684, 28685, 28686, 28698, 28699, 28700, 28701, 28706, 28707, 28708, 28722, 28723
dw   28724, 28725, 28726, 28881, 28887, 28888, 28889, 28900, 28901, 28902, 28908, 28911, 28912, 28913, 28914, 28944
dw   28950, 28951, 28952, 28959, 28960, 28969, 28970, 28971, 28972, 28976, 28977, 28978, 28995, 28996, 28997, 29003
dw   29004, 29005, 29006, 29018, 29019, 29020, 29021, 29026, 29027, 29028, 29041, 29046, 29047, 29048, 29201, 29207
dw   29208, 29209, 29221, 29222, 29223, 29227, 29231, 29232, 29233, 29234, 29264, 29270, 29271, 29272, 29279, 29280
dw   29281, 29289, 29290, 29291, 29292, 29298, 29299, 29300, 29315, 29316, 29317, 29323, 29324, 29325, 29326, 29338
dw   29339, 29340, 29341, 29346, 29347, 29348, 29367, 29368, 29369, 29520, 29527, 29528, 29529, 29530, 29543, 29544
dw   29545, 29546, 29551, 29552, 29553, 29554, 29583, 29590, 29591, 29592, 29593, 29600, 29601, 29602, 29609, 29610
dw   29611, 29612, 29620, 29621, 29636, 29637, 29638, 29643, 29644, 29645, 29646, 29658, 29659, 29660, 29661, 29666
dw   29667, 29668, 29688, 29689, 29834, 29835, 29836, 29837, 29838, 29839, 29840, 29841, 29847, 29848, 29849, 29850
dw   29871, 29872, 29873, 29874, 29897, 29898, 29899, 29900, 29901, 29902, 29903, 29904, 29910, 29911, 29912, 29913
dw   29922, 29923, 29929, 29930, 29931, 29932, 29940, 29941, 29942, 29958, 29959, 29960, 29963, 29964, 29965, 29966
dw   29978, 29979, 29980, 29986, 29987, 29988, 30008, 30009, 30010, 30153, 30158, 30162, 30163, 30168, 30169, 30170
dw   30191, 30192, 30193, 30194, 30216, 30221, 30225, 30226, 30231, 30232, 30233, 30244, 30245, 30249, 30250, 30251
dw   30252, 30261, 30262, 30263, 30283, 30284, 30285, 30286, 30298, 30299, 30300, 30306, 30307, 30308, 30328, 30329
dw   30330, 30477, 30478, 30484, 30485, 30488, 30489, 30490, 30491, 30511, 30512, 30513, 30514, 30540, 30541, 30547
dw   30548, 30551, 30552, 30553, 30554, 30569, 30570, 30571, 30572, 30581, 30582, 30583, 30603, 30604, 30605, 30606
dw   30617, 30618, 30619, 30620, 30626, 30627, 30628, 30640, 30648, 30649, 30650, 30796, 30797, 30806, 30807, 30808
dw   30809, 30810, 30811, 30831, 30832, 30833, 30834, 30859, 30860, 30869, 30870, 30871, 30872, 30873, 30874, 30889
dw   30890, 30891, 30892, 30901, 30902, 30903, 30904, 30923, 30924, 30925, 30926, 30937, 30938, 30939, 30946, 30947
dw   30948, 30955, 30960, 30968, 30969, 31115, 31116, 31127, 31128, 31129, 31130, 31131, 31132, 31151, 31152, 31153
dw   31154, 31178, 31179, 31190, 31191, 31192, 31193, 31194, 31195, 31209, 31210, 31211, 31212, 31221, 31222, 31223
dw   31224, 31244, 31245, 31246, 31247, 31257, 31258, 31266, 31267, 31268, 31274, 31275, 31276, 31280, 31281, 31288
dw   31433, 31434, 31435, 31448, 31449, 31450, 31451, 31452, 31453, 31470, 31471, 31472, 31473, 31474, 31475, 31496
dw   31497, 31498, 31511, 31512, 31513, 31514, 31515, 31516, 31529, 31530, 31531, 31532, 31541, 31542, 31543, 31544
dw   31564, 31565, 31566, 31567, 31576, 31577, 31578, 31586, 31587, 31588, 31593, 31594, 31595, 31596, 31597, 31601
dw   31602, 31607, 31751, 31752, 31753, 31754, 31769, 31770, 31771, 31772, 31773, 31785, 31786, 31787, 31788, 31789
dw   31790, 31791, 31792, 31793, 31794, 31795, 31814, 31815, 31816, 31817, 31832, 31833, 31834, 31835, 31836, 31849
dw   31850, 31851, 31852, 31861, 31862, 31863, 31885, 31886, 31887, 31888, 31896, 31897, 31905, 31906, 31907, 31908
dw   31909, 31914, 31915, 31916, 31923, 31924, 31925, 31926, 32070, 32071, 32072, 32073, 32090, 32091, 32092, 32093
dw   32094, 32103, 32104, 32113, 32114, 32115, 32116, 32133, 32134, 32135, 32136, 32153, 32154, 32155, 32156, 32157
dw   32169, 32170, 32171, 32180, 32181, 32182, 32183, 32205, 32206, 32207, 32208, 32215, 32216, 32235, 32236, 32390
dw   32391, 32392, 32410, 32411, 32412, 32413, 32414, 32422, 32435, 32436, 32437, 32450, 32451, 32453, 32454, 32455
dw   32473, 32474, 32475, 32476, 32477, 32489, 32490, 32491, 32500, 32501, 32502, 32526, 32527, 32528, 32529, 32534
dw   32535, 32555, 32731, 32732, 32733, 32734, 32735, 32741, 32756, 32757, 32758, 32769, 32770, 32771, 32772, 32794
dw   32795, 32796, 32797, 32798, 32805, 32809, 32810, 32819, 32820, 32821, 32847, 32848, 32849, 32850, 32853, 32854
dw   33052, 33053, 33054, 33055, 33056, 33077, 33078, 33079, 33090, 33091, 33092, 33115, 33116, 33117, 33118, 33119
dw   33126, 33127, 33129, 33137, 33138, 33139, 33169, 33170, 33171, 33172, 33173, 33373, 33374, 33375, 33376, 33377
dw   33398, 33399, 33400, 33411, 33412, 33436, 33437, 33438, 33439, 33440, 33448, 33449, 33450, 33451, 33452, 33453
dw   33454, 33455, 33456, 33457, 33695, 33696, 33697, 33698, 33699, 33719, 33720, 33721, 33731, 33732, 33758, 33759
dw   33760, 33761, 33762, 34041, 34042, 34043, 34050, 34051, 34363, 34364, 34365, 34366, 34367, 34368, 34369
textlen         equ $ - text

mousex          dw      ?
x               dw      ?
y               dw      ?
lx              dw      ?
ly              dw      ?
i               dw      ?
j               dw      ?
coul1           dw      ?
coul2           dw      ?
pathind         dw      ?
centerx         dw      ?
centery         dw      ?
xinc            dw      ?
yinc            dw      ?

code    Ends

        End     Start