;-----------------------------------------------------------------------------
; EnabA20.asm - by Jake Richter (& IBM) 07/13/88
;
; This routine enables Address Line 20 from the 80X86 processor when making
; memory references. Default is to drive A20 low, i.e. A20 disabled.
; The line state is controlled by the 8042 Keyboard Controller.
;
; Made executable with the following sequence:
;
; MASM EnabA20;
; LINK EnabA20;
; EXE2BIN EnabA20 EnabA20.com
;
;
COM8042    equ     064H
DAT8042    equ     060H



Cseg       segment
           assume  CS:Cseg, DS:Cseg
           org     100H                    ; Needed for COM file.
Gate20     proc    near
           cli                             ; Disable interrupts.
           call    WaitOn8042              ; Make sure 8042 input buff is empty.
           jnz     Gate20_Ret              ; Leave if command not accepted.
           mov     AL, 0D1H                ; 8042 CMD -> Write Output Port
           out     COM8042, AL             ; Send command to 8042.
           call    WaitOn8042              ; Wait for 8042 to ACK.
           jnz     Gate20_Ret              ; If it doesn't, exit.
           mov     AL, 0DFH                ; Grab A20 enable value.
                                           ; To disable, use 0DDH instead.
           out     DAT8042, AL             ; Send it.
           call    WaitOn8042              ; Wait for 8042 one last time.
           sti                             ; Restore interrupts.
Gate20_Ret:
;          cmp     AL, 0                   ; Implement if error check
;                                          ; is needed...
;          jne     DidNotWork
           ret                             ; Return to DOS.
Gate20     endp

WaitOn8042 proc    near
           xor     CX, CX                  ; Clear timeout counter.
WaitLoop:
           in      AL, COM8042             ; Read 8042 status.
           and     AL, 02                  ; Test for input buffer full.
           loopnz  WaitLoop                ; Wait until timeout or OK.
           ret
WaitOn8042 endp

Cseg       ends
           end
