include	asm.inc

altf	equ	0121h
altb	equ	0130h

extrn	gcenter:proc, gcenterx:proc
extrn	gprintup:proc, gprintdown:proc
extrn	gprintupx:proc, gprintdown:proc
extrn	hgraph:proc, gprint:proc
extrn	fillbox:proc, htext:proc
extrn	fillpattern:proc, getkey:proc
extrn	gcolor:proc, resetview:proc, gclear:proc
extrn	toupper:proc
extrn	graphmode:proc, textmode:proc

.data
extrn	drawmode:byte
x	dw 0,0,719,347

gc	db 'GCenter',0
gcx	db 'GCenterX',0
gpu	db 'GPrintUP',0
gpux	db 'GPrintUPX',0
gpd	db 'GPrintDOWN',0

p0	db ' Drawmode 0; XOR foreground with screen ',0
p1	db ' Drawmode 1; print character with background ',0
p2	db ' Drawmode 2; print character without background ',0
n1	db ' Drawmode -1; print character with background, reverse video ',0
n2	db ' Drawmode -2; print character without background, reverse video ',0
bottom	dw 2 dup (0)

aligned	db 'test alignment',0
pattern	db 4 dup (10101010b,01010101b)
	db 0
prnmode		db 1
prncolor	db 7,0
cflag		db 1

.code
public	gptest
gptest	proc
	pushf
	push	bp
	push	ax
	push	bx
	push	cx
	push	dx
	push	di
	push	si
	push	ds
	push	es
	call	graphmode
	call	resetview
	mov	ax,es:6[bx]
	sub	ax,14
	mov	bottom+2,ax
	mov	ax,es:4[bx]
	mov	x+4,ax
	mov	prnmode,1
	mov	cflag,0
again:
	call	gclear
	mov	ax,1
	call	gcolor
	mov	drawmode,1
	lea	bx,pattern
	call	fillpattern
	call	resetview
	mov	ax,es:4[bx]
	inc	ax
	shr	ax,1
	mov	x,ax
	lea	bx,x
	call	fillbox

	mov	ax,word ptr prncolor
	call	gcolor

	call	print_center
	call	print_sides
	call	print_updown

	mov	x,0
	mov	x+2,0

read_next_key:
	call	getkey
	cmp	ax,altf
	jne	r0
	mov	cflag,0		; falls into altb test, which fails
				; test for extended character bumps it
				; back to read_next_key
r0:	cmp	ax,altb
	jne	r1
	mov	cflag,1
r1:	shr	ah,1
	jc	read_next_key
	cmp	al,'+'
	je	plus
	cmp	al,'-'
	je	minus
	cmp	ax,27
	je	exit
	cmp	al,'0'
	jb	read_next_key
	cmp	al,'9'
	jbe	new_color
	call	toupper
	cmp	al,'A'
	jb	read_next_key
	cmp	al,'F'
	ja	read_next_key
	sub	al,'A'-58

new_color:
	sub	al,'0'
	cmp	cflag,1
	je	new_back
	mov	prncolor,al
	jmp	again
new_back:
	mov	prncolor+1,al
	jmp	again

plus:	inc	prnmode
	cmp	prnmode,2
	jg	fix1
	jmp	again
fix1:	mov	prnmode,2
	jmp	read_next_key

minus:	dec	prnmode
	cmp	prnmode,-2
	jl	fix2
	jmp	again
fix2:	mov	prnmode,-2
	jmp	read_next_key
exit:	call	textmode
	pop	es
	pop	ds
	pop	si
	pop	di
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	pop	bp
	popf
	ret
gptest	endp

print_center	proc near
	mov	al,drawmode
	mov	drawmode,1
	mov	ah,prnmode
	lea	dx,bottom
	lea	si,p0
	or	ah,ah
	jz	pc
	jg	pc0
	lea	si,n1
	inc	ah
	jz	pc
	lea	si,n2
	jmp	short pc
pc0:	lea	si,p1
	dec	ah
	jz	pc
	lea	si,p2
pc:	call	gcenter
	mov	drawmode,al
	mov	al,prnmode
	mov	drawmode,al
	mov	dx,bx
	lea	si,gc
	call	gcenter
	add	word ptr [bx+2],15
	lea	si,gcx
	call	gcenterx
	ret
print_center	endp

print_sides	proc near
	mov	x,0
	mov	x+2,32
	lea	dx,x
	lea	si,aligned
	mov	cx,10
ps1:	mov	ax,cx
	call	gprint
	mov	cx,ax
	inc	x
	add	x+2,15
	loop	ps1

	mov	x+2,32
	mov	ax,x+4
	shr	ax,1
	add	ax,2
	mov	x,ax

	mov	cx,10
ps2:	mov	ax,cx
	call	gprint
	mov	cx,ax
	inc	x
	add	x+2,15
	loop	ps2

	ret
print_sides	endp

print_updown	proc near
	lea	di,gpux
	mov	ax,bottom+2
	shr	ax,1
	mov	x+2,ax
	mov	ax,x
	shr	ax,1
	add	x,ax
	lea	si,gpu
	call	gprintup
	add	x,9
	xchg	si,di
	call	gprintupx
	shl	ax,1
	sub	x,ax
	call	gprintupx
	sub	x,9
	xchg	si,di
	call	gprintup
	ret
print_updown	endp
	end
