page 255,255
comment |

Ŀ
Command line library. Copyright January 2001 Martin Vogler.


This program shows some capabilities of the CMDLINE-library.

To assemble and link the source these files are required:

TASM32.EXE	version 5
TLINK.EXE	version 4
CMDLINE.INC	Assembler function declarations
C0C.OBJ         BC 3.1-Object initialization file, model COMPACT
CC.LIB		BC 3.1-Library file, model COMPACT
CMDLIN16.LIB	The CMDLINE-library itself

1. Assemble the source file to an object file:
	TASM32.EXE /m /mx CMDLDEMO.ASM

2. Link the object file to an executable:
	TLINK /3 /x c0c cmdldemo,cmdldemo,,cc

Note:	Only necessary options are given.
	Make sure all paths point to their right locations.

|

.386
.model use16 compact,c
.code
include cmdline.inc

;Declaration of C-functions----------------------------------------------

printf		procdesc fstr:dword,args:dword:?
sprintf		procdesc dest:dword,fstr:dword,args:dword:?

;Main program------------------------------------------------------------
public main
main proc argc:word,argv:dword,argenv:dword
	call pspcmdline				;get commandline from psp
	movzx cx,paramcnt
	.if !cx&cx				;test if a parameter is available
	call printf,cs offset txtnoparams,\	;no parameters, exit with help
			cs offset ustr1,\
			cs offset ustr2,\
			cs offset ustr3
	jmp @@x
	.endif
	xor al,al

	.repeat
	inc ax
	push cx ax			;CX used as parameter counter
	push ds				;save DS, it could be destroyed
	call parapos			;get parameter by position in AL
	mov di,ds			;DI=segment part in case of a string
	pop ds
	xor dh,dh
	xor cx,cx

	.if ah&ah
	mov cl,ah			;user option #
	pusha				;TMPSTR="User option #..."
	call sprintf,ds offset tmpstr,cs offset s_useroption,cx
	popa
	.else
	mov tmpstr,ah			;standard parameter, clear TMPSTR
	.endif
	push ds offset tmpstr
	pop ecx				;ECX=Addr TMPSTR (for easier access)

	.if al==tstr			;type=string
	 call printf,cs offset s_string,dx,ecx,di si

	.elseif al==tbol		;type=boolean
	 mov ax,offset s_booltrue	;offset for "TRUE"
	 .if !bl & bl			;offset for "FALSE"
	 mov ax,offset s_boolfalse
	 .endif
	 call printf,cs ax,dx,ecx

	.elseif al==tnum		;type=number
	 call printf,cs offset s_num,dx,ecx,ebx,ebx

	.elseif al==tdrv		;type=drive
	 add bl,'A'			;Drive number is in BL
	 call printf,cs offset s_drive,dx,ecx,bx
	.endif

	pop ax cx			;get counter for PARAPOS -> AX
	dec cx
	.until zero?			;next parameter

@@x:	ret				;quit from C main procedure
endp


;Help text---------------------------------------------------------------
txtnoparams	db'Demonstration program for command line library.',10,10
	 	db'No commandline parameters specified.',10
		db'Available options are:',10
		db 10,'%s'
		db 10,'%s'
		db 10,'%s'
		db 10,10,'See README.TXT how this program will interpret a given string.',0


;Format strings----------------------------------------------------------
s_string	db'Parameter %2d: %sString,  "%s"',10,0
s_booltrue	db'Parameter %2d: %sBoolean, True',10,0
s_boolfalse	db'Parameter %2d: %sBoolean, False',10,0
s_num		db'Parameter %2d: %sNumber,  %lu(dec)= %lX(hex)',10,0
s_drive		db'Parameter %2d: %sDrive,   %c:',10,0
s_useroption	db'User option #%d, ',0


;Available options-------------------------------------------------------
optiontab	label byte	;string table for options, see README.TXT
ustr1		db'USEROPT1',0
ustr2		db'USEROPTA',0
ustr3		db'USEROPTX',0
optend		label byte


;Other uninitialized data------------------------------------------------
.data?
tmpstr	db 256 dup(?)		;temporary string buffer

.stack 256

end