
	name	overlay
	title	'OVERLAY segment'
;
; OVERLAY.OVL --- a simple overlay segment
; loaded by ROOT.EXE to demonstrate use of
; the MS-DOS EXEC call subfunction 03H.
; 
; The overlay does not contain a STACK segment
; because it uses the ROOT segment's stack.
;
; Ray Duncan, June 1987
;

stdin	equ	0	; standard input
stdout	equ	1	; standard output
stderr	equ	2	; standard error

cr	equ	0dh	; ASCII carriage return
lf	equ	0ah	; ASCII linefeed


_TEXT	segment byte public 'CODE'	; executable code segment

	assume  cs:_TEXT,ds:_DATA

ovlay	proc	far	; entry point from root segment

	mov	ax,_DATA	; set DS = local data segment
	mov	ds,ax

			; display overlay message ...
	mov	dx,offset msg	; DS:DX = address of message
	mov	cx,msg_len	; CX = length of message
	mov	bx,stdout	; BX = standard output handle
	mov	ah,40h	; AH = fxn 40h, write file/device
	int	21h	; transfer to MS-DOS

	ret		; return to root segment

ovlay	endp		; end of ovlay procedure

_TEXT	ends


_DATA	segment para public 'DATA'	; static & variable data segment

msg	db	cr,lf,'Overlay executing!',cr,lf
msg_len equ 	$-msg

_DATA	ends

	end


